/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.deployment.contracts;

import com.mulesoft.mule.runtime.gw.api.ApiContracts;
import com.mulesoft.mule.runtime.gw.api.contract.Sla;
import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.mule.runtime.gw.client.dto.PlatformContractAdapter;
import com.mulesoft.mule.runtime.gw.deployment.ApiService;
import com.mulesoft.mule.runtime.gw.deployment.contracts.ContractSnapshot;
import com.mulesoft.mule.runtime.gw.deployment.contracts.Snapshot;
import com.mulesoft.mule.runtime.gw.logging.GatewayMuleAppLoggerFactory;
import com.mulesoft.mule.runtime.gw.model.contracts.ClientFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import org.slf4j.Logger;

public class ContractSnapshots {
    private static final Logger LOGGER = GatewayMuleAppLoggerFactory.getLogger(ContractSnapshots.class);
    private final ApiService apiService;
    private final Lock lock;
    private Map<ApiKey, Snapshot> snapshots = new HashMap<ApiKey, Snapshot>();
    private final ClientFactory clientFactory;

    public ContractSnapshots(ApiService apiService, Lock lock, ClientFactory clientFactory) {
        this.apiService = apiService;
        this.lock = lock;
        this.clientFactory = clientFactory;
    }

    public ContractSnapshots slas(ApiKey key, List<Sla> slas) {
        LOGGER.debug("Updating SLAs for API: {}", (Object)key);
        this.atomically(() -> this.update(key, this.snapshot(key).platformSlas(slas)));
        return this;
    }

    public ContractSnapshots clients(ApiKey key, List<PlatformContractAdapter> platformContractAdapters) {
        LOGGER.debug("Updating Contracts for API: {}", (Object)key);
        this.atomically(() -> this.update(key, this.snapshot(key).platformContracts(platformContractAdapters)));
        return this;
    }

    private Snapshot snapshot(ApiKey key) {
        return this.snapshots.computeIfAbsent(key, apiKey -> this.apiService.get(key).filter(api -> api.getContracts().contractsLoaded()).map(api -> new ContractSnapshot(api.getContracts().contracts(), this.clientFactory)).orElseGet(() -> new ContractSnapshot(this.clientFactory)));
    }

    private void update(ApiKey key, Snapshot newSnapshot) {
        this.snapshots.put(key, newSnapshot);
        this.apiService.getContracts(key).ifPresent(api -> {
            newSnapshot.contracts().ifPresent(arg_0 -> ((ApiContracts)api).updateContracts(arg_0));
            newSnapshot.slas().ifPresent(arg_0 -> ((ApiContracts)api).updateSlas(arg_0));
        });
    }

    private void atomically(Runnable closure) {
        this.lock.lock();
        closure.run();
        this.lock.unlock();
    }
}

