/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.deployment.replication;

import com.mulesoft.mule.runtime.gw.api.contract.Sla;
import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.mule.runtime.gw.deployment.api.ApiService;
import com.mulesoft.mule.runtime.gw.deployment.contracts.ContractSnapshots;
import com.mulesoft.mule.runtime.gw.deployment.replication.ApiConfigurationCache;
import com.mulesoft.mule.runtime.gw.deployment.replication.DistributedApiConfigurationEntry;
import com.mulesoft.mule.runtime.gw.deployment.replication.DistributedPoliciesMapEntryListener;
import com.mulesoft.mule.runtime.gw.deployment.tracking.ApiTrackingService;
import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;
import com.mulesoft.mule.runtime.gw.model.PolicySet;
import com.mulesoft.mule.runtime.gw.model.contracts.repository.ContractRepository;
import com.mulesoft.mule.runtime.gw.policies.service.PolicySetDeploymentService;
import com.mulesoft.mule.runtime.module.cluster.api.map.ClusterMap;
import com.mulesoft.mule.runtime.module.cluster.api.map.EntryListener;
import com.mulesoft.mule.runtime.module.cluster.internal.HazelcastClusterManager;
import com.mulesoft.mule.runtime.module.cluster.internal.lock.HazelcastLockProvider;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.locks.Lock;

public class DistributedApiConfigurationCache
implements ApiConfigurationCache {
    private static final String POLICIES_MAP_NAME = "gateway-policies-map-*".substring(0, "gateway-policies-map-*".length() - 1) + "policies";
    private final ApiService apiService;
    private final PolicySetDeploymentService policySetDeploymentService;
    private final ContractSnapshots contractSnapshots;
    private final HazelcastClusterManager hazelcastManager;
    private final ContractRepository contractRepository;
    private ClusterMap<String, DistributedApiConfigurationEntry> entries;

    public DistributedApiConfigurationCache(ApiService apiService, PolicySetDeploymentService policySetDeploymentService, ContractSnapshots contractSnapshots, HazelcastClusterManager hazelcastManager, ContractRepository contractRepository) {
        this.apiService = apiService;
        this.policySetDeploymentService = policySetDeploymentService;
        this.contractSnapshots = contractSnapshots;
        this.hazelcastManager = hazelcastManager;
        this.entries = hazelcastManager.getMap(this.getPoliciesMapName());
        this.contractRepository = contractRepository;
    }

    @Override
    public void set(ApiKey apiKey, PolicySet policySet, List<Sla> slas) {
        this.entries.put((Object)this.getKey(apiKey), (Object)this.entry(policySet, slas));
    }

    @Override
    public void remove(ApiKey apiKey) {
        this.entries.remove((Object)this.getKey(apiKey));
    }

    @Override
    public Optional<PolicySet> getPolicies(ApiKey apiKey) {
        if (this.entries.containsKey((Object)this.getKey(apiKey))) {
            return this.safeGetEntry(apiKey).map(DistributedApiConfigurationEntry::getPolicySet);
        }
        return this.contractRepository.containsSla(apiKey) ? Optional.of(this.fileSystemSet(Collections.emptyList())) : Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialise(ApiTrackingService apiTrackingService) {
        Map initialPolicies = this.policySetDeploymentService.storedOnlinePoliciesByApi();
        Lock lock = new HazelcastLockProvider(this.hazelcastManager.getClusterId(), this.hazelcastManager.getHazelcastInstance(), "gw").createLock(this.getPoliciesMapName());
        try {
            lock.lock();
            initialPolicies.forEach((apiKey, policyDefinitions) -> {
                if (this.hazelcastManager.isPrimaryPollingInstance()) {
                    if (this.entries.containsKey((Object)this.getKey((ApiKey)apiKey)) && this.getEntry((ApiKey)apiKey).getPolicySet().isFromPlatform()) {
                        this.policySetDeploymentService.conciliatePolicies(apiKey, this.getEntry((ApiKey)apiKey).getPolicySet().getPolicyDefinitions());
                    } else {
                        this.entries.put((Object)this.getKey((ApiKey)apiKey), (Object)this.entry(this.fileSystemSet((List<PolicyDefinition>)policyDefinitions), Collections.emptyList()));
                    }
                } else if (this.entries.containsKey((Object)this.getKey((ApiKey)apiKey))) {
                    this.policySetDeploymentService.conciliatePolicies(apiKey, this.getEntry((ApiKey)apiKey).getPolicySet().getPolicyDefinitions());
                } else {
                    this.entries.put((Object)this.getKey((ApiKey)apiKey), (Object)this.entry(this.fileSystemSet((List<PolicyDefinition>)policyDefinitions), Collections.emptyList()));
                }
            });
            this.entries.addEntryListener((EntryListener)new DistributedPoliciesMapEntryListener(this.apiService, apiTrackingService, this.policySetDeploymentService, this.contractSnapshots, this.hazelcastManager.isClientModeEnabled()));
        }
        finally {
            lock.unlock();
        }
    }

    private String getKey(ApiKey apiKey) {
        return apiKey.id().toString();
    }

    private DistributedApiConfigurationEntry entry(PolicySet policySet, List<Sla> slas) {
        return new DistributedApiConfigurationEntry(policySet, slas);
    }

    private Optional<DistributedApiConfigurationEntry> safeGetEntry(ApiKey apiKey) {
        return Optional.ofNullable((DistributedApiConfigurationEntry)this.entries.get((Object)this.getKey(apiKey)));
    }

    private DistributedApiConfigurationEntry getEntry(ApiKey apiKey) {
        return (DistributedApiConfigurationEntry)this.entries.get((Object)this.getKey(apiKey));
    }

    private PolicySet fileSystemSet(List<PolicyDefinition> policyDefinitions) {
        return new PolicySet(policyDefinitions, PolicySet.PolicySetOrigin.FILE_SYSTEM);
    }

    private String getPoliciesMapName() {
        return this.hazelcastManager.getClusterId() + "_" + POLICIES_MAP_NAME;
    }
}

