/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.deployment.contracts;

import com.github.valfirst.slf4jtest.LoggingEvent;
import com.github.valfirst.slf4jtest.TestLogger;
import com.github.valfirst.slf4jtest.TestLoggerFactory;
import com.mulesoft.anypoint.tests.PolicyTestValuesConstants;
import com.mulesoft.anypoint.tests.logger.LogMatcher;
import com.mulesoft.mule.runtime.gw.api.contract.Contract;
import com.mulesoft.mule.runtime.gw.api.contract.Sla;
import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.mule.runtime.gw.client.dto.PlatformContractAdapter;
import com.mulesoft.mule.runtime.gw.deployment.api.ApiService;
import com.mulesoft.mule.runtime.gw.deployment.contracts.ContractSnapshots;
import com.mulesoft.mule.runtime.gw.deployment.contracts.ContractSnapshotsTestCase;
import com.mulesoft.mule.runtime.gw.deployment.mocks.BlowUpLock;
import com.mulesoft.mule.runtime.gw.model.contracts.ClientFactory;
import com.mulesoft.mule.runtime.gw.model.contracts.DefaultClientFactory;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import uk.org.lidalia.slf4jext.Level;

@RunWith(value=MockitoJUnitRunner.class)
public class ContractSnapshotsUnitTestCase
extends ContractSnapshotsTestCase {
    @Test
    public void oneTierOneClient() {
        this.snapshots.slas(this.apiKey(), Arrays.asList(this.sla(1))).clients(this.apiKey(), Arrays.asList(this.platformContractAdapter(1)));
        this.checkContractsUpdatesAndMockedInvocations(EMPTY_UPDATE, Arrays.asList(this.contractSingleLimit(1)));
        this.checkSlaUpdates(Arrays.asList(this.sla(1)), Arrays.asList(this.sla(1)));
    }

    @Test
    public void oneClientOneTier() {
        this.snapshots.clients(this.apiKey(), Arrays.asList(this.platformContractAdapter(1))).slas(this.apiKey(), Arrays.asList(this.sla(1)));
        this.checkContractsUpdatesAndMockedInvocations(Arrays.asList(this.noSlaContractForClient(1)), Arrays.asList(this.contractSingleLimit(1)));
        this.checkSlaUpdates(EMPTY_SLA_UPDATE, Arrays.asList(this.sla(1)));
    }

    @Test
    public void updateTier() {
        this.snapshots.slas(this.apiKey(), Arrays.asList(this.sla(1))).clients(this.apiKey(), Arrays.asList(this.platformContractAdapter(1))).slas(this.apiKey(), Arrays.asList(this.anotherSla(1)));
        this.checkContractsUpdatesAndMockedInvocations(EMPTY_UPDATE, Arrays.asList(this.contractSingleLimit(1)), Arrays.asList(this.contract(this.anotherSla(1), this.client(1))));
        this.checkSlaUpdates(Arrays.asList(this.sla(1)), Arrays.asList(this.sla(1)), Arrays.asList(this.anotherSla(1)));
    }

    @Test
    public void updateClient() {
        this.snapshots.clients(this.apiKey(), Arrays.asList(this.platformContractAdapter(1))).slas(this.apiKey(), Arrays.asList(this.sla(1))).clients(this.apiKey(), Arrays.asList(this.anotherPlatformContractAdapter(1)));
        this.checkContractsUpdatesAndMockedInvocations(Arrays.asList(this.noSlaContractForClient(1)), Arrays.asList(this.contractSingleLimit(1)), Arrays.asList(this.contract(this.sla(1), this.anotherClient(1))));
        this.checkSlaUpdates(EMPTY_SLA_UPDATE, Arrays.asList(this.sla(1)), Arrays.asList(this.sla(1)));
    }

    @Test
    public void consecutiveIdempotentTierUpdate() {
        this.snapshots.clients(this.apiKey(), Arrays.asList(this.platformContractAdapter(1))).slas(this.apiKey(), Arrays.asList(this.sla(1))).slas(this.apiKey(), Arrays.asList(this.sla(1)));
        this.checkContractsUpdatesAndMockedInvocations(Arrays.asList(this.noSlaContractForClient(1)), Arrays.asList(this.contractSingleLimit(1)), Arrays.asList(this.contractSingleLimit(1)));
        this.checkSlaUpdates(EMPTY_SLA_UPDATE, Arrays.asList(this.sla(1)), Arrays.asList(this.sla(1)));
    }

    @Test
    public void interleavedIdempotentTierUpdate() {
        this.snapshots.slas(this.apiKey(), Arrays.asList(this.sla(1))).clients(this.apiKey(), Arrays.asList(this.platformContractAdapter(1))).slas(this.apiKey(), Arrays.asList(this.sla(1)));
        this.checkContractsUpdatesAndMockedInvocations(EMPTY_UPDATE, Arrays.asList(this.contractSingleLimit(1)), Arrays.asList(this.contractSingleLimit(1)));
        this.checkSlaUpdates(Arrays.asList(this.sla(1)), Arrays.asList(this.sla(1)), Arrays.asList(this.sla(1)));
    }

    @Test
    public void firstIdempotentTierUpdate() {
        this.snapshots.slas(this.apiKey(), Arrays.asList(this.sla(1))).slas(this.apiKey(), Arrays.asList(this.sla(1))).clients(this.apiKey(), Arrays.asList(this.platformContractAdapter(1)));
        this.checkContractsUpdatesAndMockedInvocations(EMPTY_UPDATE, EMPTY_UPDATE, Arrays.asList(this.contractSingleLimit(1)));
        this.checkSlaUpdates(Arrays.asList(this.sla(1)), Arrays.asList(this.sla(1)), Arrays.asList(this.sla(1)));
    }

    @Test
    public void consecutiveIdempotentClientUpdate() {
        this.snapshots.slas(this.apiKey(), Arrays.asList(this.sla(1))).clients(this.apiKey(), Arrays.asList(this.platformContractAdapter(1))).clients(this.apiKey(), Arrays.asList(this.platformContractAdapter(1)));
        this.checkContractsUpdatesAndMockedInvocations(EMPTY_UPDATE, Arrays.asList(this.contractSingleLimit(1)), Arrays.asList(this.contractSingleLimit(1)));
        this.checkSlaUpdates(Arrays.asList(this.sla(1)), Arrays.asList(this.sla(1)), Arrays.asList(this.sla(1)));
    }

    @Test
    public void interleavedIdempotentClientUpdate() {
        this.snapshots.clients(this.apiKey(), Arrays.asList(this.platformContractAdapter(1))).slas(this.apiKey(), Arrays.asList(this.sla(1))).clients(this.apiKey(), Arrays.asList(this.platformContractAdapter(1)));
        this.checkContractsUpdatesAndMockedInvocations(Arrays.asList(this.noSlaContractForClient(1)), Arrays.asList(this.contractSingleLimit(1)), Arrays.asList(this.contractSingleLimit(1)));
        this.checkSlaUpdates(EMPTY_SLA_UPDATE, Arrays.asList(this.sla(1)), Arrays.asList(this.sla(1)));
    }

    @Test
    public void firstIdempotentClientUpdate() {
        this.snapshots.clients(this.apiKey(), Arrays.asList(this.platformContractAdapter(1))).clients(this.apiKey(), Arrays.asList(this.platformContractAdapter(1))).slas(this.apiKey(), Arrays.asList(this.sla(1)));
        this.checkContractsUpdatesAndMockedInvocations(Arrays.asList(this.noSlaContractForClient(1)), Arrays.asList(this.noSlaContractForClient(1)), Arrays.asList(this.contractSingleLimit(1)));
        this.checkSlaUpdates(EMPTY_SLA_UPDATE, EMPTY_SLA_UPDATE, Arrays.asList(this.sla(1)));
    }

    @Test
    public void unmatchedTierId() {
        this.snapshots.clients(this.apiKey(), Arrays.asList(this.platformContractAdapter(1))).slas(this.apiKey(), Arrays.asList(this.sla(1902)));
        this.checkContractsUpdatesAndMockedInvocations(Arrays.asList(this.noSlaContractForClient(1)), Arrays.asList(this.noSlaContractForClient(1)));
        this.checkSlaUpdates(EMPTY_SLA_UPDATE, Arrays.asList(this.sla(1902)));
    }

    @Test
    public void unmatchedClientTierId() {
        this.snapshots.slas(this.apiKey(), Arrays.asList(this.sla(1))).clients(this.apiKey(), Arrays.asList(this.platformContractAdapter(1902)));
        this.checkContractsUpdatesAndMockedInvocations(EMPTY_UPDATE, Arrays.asList(this.noSlaContractForClient(1902)));
        this.checkSlaUpdates(Arrays.asList(this.sla(1)), Arrays.asList(this.sla(1)));
    }

    @Test
    public void slaWithMultipleLimits() {
        this.snapshots.clients(this.apiKey(), Arrays.asList(this.platformContractAdapter(1))).slas(this.apiKey(), Arrays.asList(this.slaWithMultipleLimits(1)));
        this.checkContractsUpdatesAndMockedInvocations(Arrays.asList(this.noSlaContractForClient(1)), Arrays.asList(this.contractMultiLimit(1)));
        this.checkSlaUpdates(EMPTY_SLA_UPDATE, Arrays.asList(this.slaWithMultipleLimits(1)));
    }

    @Test
    public void multipleTiersOneClient() {
        this.snapshots.clients(this.apiKey(), Arrays.asList(this.platformContractAdapter(1))).slas(this.apiKey(), Arrays.asList(this.slaWithMultipleLimits(1902), this.sla(1)));
        this.checkContractsUpdatesAndMockedInvocations(Arrays.asList(this.noSlaContractForClient(1)), Arrays.asList(this.contractSingleLimit(1)));
        this.checkSlaUpdates(EMPTY_SLA_UPDATE, Arrays.asList(this.sla(1), this.slaWithMultipleLimits(1902)));
    }

    @Test
    public void multipleClientsOneTier() {
        this.snapshots.clients(this.apiKey(), Arrays.asList(this.platformContractAdapter(1902), this.platformContractAdapter(1))).slas(this.apiKey(), Arrays.asList(this.sla(1)));
        this.checkContractsUpdatesAndMockedInvocations(Arrays.asList(this.noSlaContractForClient(1902), this.noSlaContractForClient(1)), Arrays.asList(this.noSlaContractForClient(1902), this.contractSingleLimit(1)));
        this.checkSlaUpdates(EMPTY_SLA_UPDATE, Arrays.asList(this.sla(1)));
    }

    @Test
    public void multipleTiersAndClients() {
        this.snapshots.clients(this.apiKey(), Arrays.asList(this.platformContractAdapter(1902), this.platformContractAdapter(1))).slas(this.apiKey(), Arrays.asList(this.sla(1), this.slaWithMultipleLimits(1902)));
        this.checkContractsUpdatesAndMockedInvocations(Arrays.asList(this.noSlaContractForClient(1902), this.noSlaContractForClient(1)), Arrays.asList(this.contractMultiLimit(1902), this.contractSingleLimit(1)));
        this.checkSlaUpdates(EMPTY_SLA_UPDATE, Arrays.asList(this.sla(1), this.slaWithMultipleLimits(1902)));
    }

    @Test
    public void clearContractsWhenClientsRemoved() {
        this.snapshots.clients(this.apiKey(), Arrays.asList(this.platformContractAdapter(1902), this.platformContractAdapter(1))).slas(this.apiKey(), Arrays.asList(this.sla(1), this.slaWithMultipleLimits(1902))).clients(this.apiKey(), Arrays.asList(new PlatformContractAdapter[0]));
        this.checkContractsUpdatesAndMockedInvocations(Arrays.asList(this.noSlaContractForClient(1902), this.noSlaContractForClient(1)), Arrays.asList(this.contractMultiLimit(1902), this.contractSingleLimit(1)), Arrays.asList(new Contract[0]));
        this.checkSlaUpdates(EMPTY_SLA_UPDATE, Arrays.asList(this.sla(1), this.slaWithMultipleLimits(1902)), Arrays.asList(this.sla(1), this.slaWithMultipleLimits(1902)));
    }

    @Test
    public void removeClientWithSla() {
        this.snapshots.clients(this.apiKey(), Arrays.asList(this.platformContractAdapter(1902), this.platformContractAdapter(1))).slas(this.apiKey(), Arrays.asList(this.sla(1), this.slaWithMultipleLimits(1902))).clients(this.apiKey(), Arrays.asList(this.platformContractAdapter(1)));
        this.checkContractsUpdatesAndMockedInvocations(Arrays.asList(this.noSlaContractForClient(1902), this.noSlaContractForClient(1)), Arrays.asList(this.contractMultiLimit(1902), this.contractSingleLimit(1)), Arrays.asList(this.contractSingleLimit(1)));
        this.checkSlaUpdates(EMPTY_SLA_UPDATE, Arrays.asList(this.sla(1), this.slaWithMultipleLimits(1902)), Arrays.asList(this.sla(1), this.slaWithMultipleLimits(1902)));
    }

    @Test
    public void removeClientWithNoSla() {
        String noSla = null;
        this.snapshots.clients(this.apiKey(), Arrays.asList(this.platformContractAdapter(noSla), this.anotherPlatformContractAdapter(noSla))).clients(this.apiKey(), Arrays.asList(this.platformContractAdapter(noSla)));
        this.checkContractsUpdatesAndMockedInvocations(Arrays.asList(this.noSlaContractForClient(noSla), this.noSlaContractForAnotherClient(noSla)), Arrays.asList(this.noSlaContractForClient(noSla)));
        this.checkSlaUpdates(EMPTY_SLA_UPDATE, EMPTY_SLA_UPDATE);
    }

    @Test
    public void removeClientWithAndWithoutSla() {
        String noSla = null;
        this.snapshots.clients(this.apiKey(), Arrays.asList(this.platformContractAdapter(noSla), this.anotherPlatformContractAdapter(noSla), this.aThirdPlatformContractAdapter(1))).slas(this.apiKey(), Arrays.asList(this.sla(1), this.slaWithMultipleLimits(1902))).clients(this.apiKey(), Arrays.asList(this.platformContractAdapter(noSla)));
        this.checkContractsUpdatesAndMockedInvocations(Arrays.asList(this.noSlaContractForClient(noSla), this.noSlaContractForAnotherClient(noSla), this.noSlaContractForThirdClient(1)), Arrays.asList(this.noSlaContractForClient(noSla), this.noSlaContractForAnotherClient(noSla), this.contract(this.sla(1), this.aThirdClient(1))), Arrays.asList(this.noSlaContractForClient(noSla)));
        this.checkSlaUpdates(EMPTY_SLA_UPDATE, Arrays.asList(this.sla(1), this.slaWithMultipleLimits(1902)), Arrays.asList(this.sla(1), this.slaWithMultipleLimits(1902)));
    }

    @Test
    public void removeClientWithNoSlaButLeaveAnotherWithSla() {
        String noSla = null;
        this.snapshots.clients(this.apiKey(), Arrays.asList(this.platformContractAdapter(noSla), this.anotherPlatformContractAdapter(noSla), this.aThirdPlatformContractAdapter(1))).slas(this.apiKey(), Arrays.asList(this.sla(1), this.slaWithMultipleLimits(1902))).clients(this.apiKey(), Arrays.asList(this.platformContractAdapter(noSla), this.aThirdPlatformContractAdapter(1)));
        this.checkContractsUpdatesAndMockedInvocations(Arrays.asList(this.noSlaContractForClient(noSla), this.noSlaContractForAnotherClient(noSla), this.noSlaContractForThirdClient(1)), Arrays.asList(this.noSlaContractForClient(noSla), this.noSlaContractForAnotherClient(noSla), this.contract(this.sla(1), this.aThirdClient(1))), Arrays.asList(this.noSlaContractForClient(noSla), this.contract(this.sla(1), this.aThirdClient(1))));
        this.checkSlaUpdates(EMPTY_SLA_UPDATE, Arrays.asList(this.sla(1), this.slaWithMultipleLimits(1902)), Arrays.asList(this.sla(1), this.slaWithMultipleLimits(1902)));
    }

    @Test
    public void removeSlaBeingUsedByClient() {
        this.snapshots.slas(this.apiKey(), Arrays.asList(this.sla(1))).clients(this.apiKey(), Arrays.asList(this.platformContractAdapter(1))).slas(this.apiKey(), Arrays.asList(new Sla[0]));
        this.checkContractsUpdatesAndMockedInvocations(EMPTY_UPDATE, Arrays.asList(this.contract(this.sla(1), this.client(1))), Arrays.asList(this.contract(this.sla(1), this.client(1))));
        this.checkSlaUpdates(Arrays.asList(this.sla(1)), Arrays.asList(this.sla(1)), Arrays.asList(this.sla(1)));
    }

    @Test
    public void changeSlaBeingUsedByClientKeepsBothSlas() {
        this.snapshots.slas(this.apiKey(), Arrays.asList(this.sla(1))).clients(this.apiKey(), Arrays.asList(this.platformContractAdapter(1))).slas(this.apiKey(), Arrays.asList(this.sla(1902))).clients(this.apiKey(), Arrays.asList(this.platformContractAdapter(1902)));
        this.checkContractsUpdatesAndMockedInvocations(EMPTY_UPDATE, Arrays.asList(this.contract(this.sla(1), this.client(1))), Arrays.asList(this.contract(this.sla(1), this.client(1))), Arrays.asList(this.contract(this.sla(1902), this.client(1902))));
        this.checkSlaUpdates(Arrays.asList(this.sla(1)), Arrays.asList(this.sla(1)), Arrays.asList(this.sla(1), this.sla(1902)), Arrays.asList(this.sla(1), this.sla(1902)));
    }

    @Test
    public void revokeClientWithNoSla() {
        String noSla = null;
        this.snapshots.clients(this.apiKey(), Arrays.asList(this.platformContractAdapter(noSla), this.anotherPlatformContractAdapter(1))).slas(this.apiKey(), Arrays.asList(this.sla(1))).clients(this.apiKey(), Arrays.asList(this.anotherPlatformContractAdapter(1))).clients(this.apiKey(), Arrays.asList(this.platformContractAdapter(noSla), this.anotherPlatformContractAdapter(1)));
        this.checkContractsUpdatesAndMockedInvocations(Arrays.asList(this.noSlaContractForClient(noSla), this.noSlaContractForAnotherClient(1)), Arrays.asList(this.noSlaContractForClient(noSla), this.contract(this.sla(1), this.anotherClient(1))), Arrays.asList(this.contract(this.sla(1), this.anotherClient(1))), Arrays.asList(this.noSlaContractForClient(noSla), this.contract(this.sla(1), this.anotherClient(1))));
        this.checkSlaUpdates(EMPTY_SLA_UPDATE, Arrays.asList(this.sla(1)), Arrays.asList(this.sla(1)), Arrays.asList(this.sla(1)));
    }

    @Test
    public void revokeClientWithSla() {
        String noSla = null;
        this.snapshots.clients(this.apiKey(), Arrays.asList(this.platformContractAdapter(noSla), this.anotherPlatformContractAdapter(1))).slas(this.apiKey(), Arrays.asList(this.sla(1))).slas(this.apiKey(), Arrays.asList(this.sla(1902))).slas(this.apiKey(), Arrays.asList(this.sla(1))).clients(this.apiKey(), Arrays.asList(this.platformContractAdapter(noSla), this.anotherPlatformContractAdapter(1)));
        this.checkContractsUpdatesAndMockedInvocations(Arrays.asList(this.noSlaContractForClient(noSla), this.noSlaContractForAnotherClient(1)), Arrays.asList(this.noSlaContractForClient(noSla), this.contract(this.sla(1), this.anotherClient(1))), Arrays.asList(this.noSlaContractForClient(noSla), this.contract(this.sla(1), this.anotherClient(1))), Arrays.asList(this.noSlaContractForClient(noSla), this.contract(this.sla(1), this.anotherClient(1))), Arrays.asList(this.noSlaContractForClient(noSla), this.contract(this.sla(1), this.anotherClient(1))));
        this.checkSlaUpdates(EMPTY_SLA_UPDATE, Arrays.asList(this.sla(1)), Arrays.asList(this.sla(1), this.sla(1902)), Arrays.asList(this.sla(1), this.sla(1902)), Arrays.asList(this.sla(1), this.sla(1902)));
    }

    @Test
    public void addClientsWithNoSla() {
        String noSla = null;
        this.snapshots.clients(this.apiKey(), Arrays.asList(this.platformContractAdapter(noSla))).clients(this.apiKey(), Arrays.asList(this.platformContractAdapter(noSla), this.anotherPlatformContractAdapter(noSla)));
        this.checkContractsUpdatesAndMockedInvocations(Arrays.asList(this.noSlaContractForClient(noSla)), Arrays.asList(this.noSlaContractForClient(noSla), this.noSlaContractForAnotherClient(noSla)));
        this.checkSlaUpdates(EMPTY_SLA_UPDATE, EMPTY_SLA_UPDATE);
    }

    @Test
    public void clientObtainsSla() {
        this.snapshots.clients(this.apiKey(), Arrays.asList(this.platformContractAdapter(null))).slas(this.apiKey(), Arrays.asList(this.sla(1))).clients(this.apiKey(), Arrays.asList(this.platformContractAdapter(1)));
        this.checkContractsUpdatesAndMockedInvocations(Arrays.asList(this.noSlaContractForClient(null)), Arrays.asList(this.noSlaContractForClient(null)), Arrays.asList(this.contractSingleLimit(1)));
        this.checkSlaUpdates(EMPTY_SLA_UPDATE, Arrays.asList(this.sla(1)), Arrays.asList(this.sla(1)));
    }

    @Test
    public void onlyOneClientChangesSla() {
        this.snapshots.clients(this.apiKey(), Arrays.asList(this.platformContractAdapter(1), this.anotherPlatformContractAdapter(1902))).slas(this.apiKey(), Arrays.asList(this.sla(1), this.slaWithMultipleLimits(1902))).clients(this.apiKey(), Arrays.asList(this.platformContractAdapter(1), this.anotherPlatformContractAdapter(1)));
        this.checkContractsUpdatesAndMockedInvocations(Arrays.asList(this.noSlaContractForClient(1), this.noSlaContractForAnotherClient(1902)), Arrays.asList(this.contract(this.sla(1), this.client(1)), this.contract(this.slaWithMultipleLimits(1902), this.anotherClient(1902))), Arrays.asList(this.contract(this.sla(1), this.client(1)), this.contract(this.sla(1), this.anotherClient(1))));
        this.checkSlaUpdates(EMPTY_SLA_UPDATE, Arrays.asList(this.sla(1), this.slaWithMultipleLimits(1902)), Arrays.asList(this.sla(1), this.slaWithMultipleLimits(1902)));
    }

    @Test
    public void multipleClientsSameTier() {
        this.snapshots.clients(this.apiKey(), Arrays.asList(this.anotherPlatformContractAdapter(1), this.platformContractAdapter(1))).slas(this.apiKey(), Arrays.asList(this.sla(1)));
        this.checkContractsUpdatesAndMockedInvocations(Arrays.asList(this.noSlaContractForAnotherClient(1), this.noSlaContractForClient(1)), Arrays.asList(this.contract(this.sla(1), this.anotherClient(1)), this.contractSingleLimit(1)));
        this.checkSlaUpdates(EMPTY_SLA_UPDATE, Arrays.asList(this.sla(1)));
    }

    @Test
    public void callTiersOrClientWithInvalidApiKey() {
        this.snapshots.clients(this.inexistentApi(), Arrays.asList(this.platformContractAdapter(1))).slas(this.inexistentApi(), Arrays.asList(this.sla(1)));
        ((ApiService)Mockito.verify((Object)this.mocks.apiService(), (VerificationMode)Mockito.times((int)2))).getContracts(this.inexistentApi());
        this.verifyApiTestInvocations();
    }

    @Test
    public void removeSlasDoesNotRemoveContracts() {
        this.snapshots.slas(this.apiKey(), Arrays.asList(this.sla(1), this.slaWithMultipleLimits(1902))).clients(this.apiKey(), Arrays.asList(this.platformContractAdapter(1902), this.platformContractAdapter(1))).slas(this.apiKey(), Arrays.asList(new Sla[0]));
        this.checkContractsUpdatesAndMockedInvocations(EMPTY_UPDATE, Arrays.asList(this.contractMultiLimit(1902), this.contractSingleLimit(1)), Arrays.asList(this.contractMultiLimit(1902), this.contractSingleLimit(1)));
        this.checkSlaUpdates(Arrays.asList(this.sla(1), this.slaWithMultipleLimits(1902)), Arrays.asList(this.sla(1), this.slaWithMultipleLimits(1902)), Arrays.asList(this.sla(1), this.slaWithMultipleLimits(1902)));
    }

    @Test
    public void deltaContractsWhenSomeTiersRemoved() {
        this.snapshots.slas(this.apiKey(), Arrays.asList(this.sla(1), this.slaWithMultipleLimits(1902))).clients(this.apiKey(), Arrays.asList(this.platformContractAdapter(1902), this.platformContractAdapter(1))).slas(this.apiKey(), Arrays.asList(this.sla(1)));
        this.checkContractsUpdatesAndMockedInvocations(EMPTY_UPDATE, Arrays.asList(this.contractMultiLimit(1902), this.contractSingleLimit(1)), Arrays.asList(this.contractMultiLimit(1902), this.contractSingleLimit(1)));
        this.checkSlaUpdates(Arrays.asList(this.sla(1), this.slaWithMultipleLimits(1902)), Arrays.asList(this.sla(1), this.slaWithMultipleLimits(1902)), Arrays.asList(this.sla(1), this.slaWithMultipleLimits(1902)));
    }

    @Test
    public void clientChangesTier() {
        this.snapshots.slas(this.apiKey(), Arrays.asList(this.sla(1), this.slaWithMultipleLimits(1902))).clients(this.apiKey(), Arrays.asList(this.platformContractAdapter(1))).clients(this.apiKey(), Arrays.asList(this.platformContractAdapter(1902)));
        this.checkContractsUpdatesAndMockedInvocations(EMPTY_UPDATE, Arrays.asList(this.contractSingleLimit(1)), Arrays.asList(this.contractMultiLimit(1902)));
        this.checkSlaUpdates(Arrays.asList(this.sla(1), this.slaWithMultipleLimits(1902)), Arrays.asList(this.sla(1), this.slaWithMultipleLimits(1902)), Arrays.asList(this.sla(1), this.slaWithMultipleLimits(1902)));
    }

    @Test
    public void clientFromNoContractToChangingItTwice() {
        this.snapshots.clients(this.apiKey(), Arrays.asList(this.platformContractAdapter(null))).slas(this.apiKey(), Arrays.asList(this.sla(1))).clients(this.apiKey(), Arrays.asList(this.platformContractAdapter(1))).slas(this.apiKey(), Arrays.asList(this.sla(1), this.sla(1902))).clients(this.apiKey(), Arrays.asList(this.platformContractAdapter(1902)));
        this.checkContractsUpdatesAndMockedInvocations(Arrays.asList(this.noSlaContractForClient(null)), Arrays.asList(this.noSlaContractForClient(null)), Arrays.asList(this.contractSingleLimit(1)), Arrays.asList(this.contractSingleLimit(1)), Arrays.asList(this.contractSingleLimit(1902)));
        this.checkSlaUpdates(EMPTY_SLA_UPDATE, Arrays.asList(this.sla(1)), Arrays.asList(this.sla(1)), Arrays.asList(this.sla(1), this.sla(1902)), Arrays.asList(this.sla(1), this.sla(1902)));
    }

    @Test
    public void clientFromNoContractToChangingItTwiceDifferentOrder() {
        this.snapshots.clients(this.apiKey(), Arrays.asList(this.platformContractAdapter(null))).clients(this.apiKey(), Arrays.asList(this.platformContractAdapter(1))).slas(this.apiKey(), Arrays.asList(this.sla(1))).slas(this.apiKey(), Arrays.asList(this.sla(1), this.sla(1902))).clients(this.apiKey(), Arrays.asList(this.platformContractAdapter(1902)));
        this.checkContractsUpdatesAndMockedInvocations(Arrays.asList(this.noSlaContractForClient(null)), Arrays.asList(this.noSlaContractForClient(null)), Arrays.asList(this.contractSingleLimit(1)), Arrays.asList(this.contractSingleLimit(1)), Arrays.asList(this.contractSingleLimit(1902)));
        this.checkSlaUpdates(EMPTY_SLA_UPDATE, EMPTY_SLA_UPDATE, Arrays.asList(this.sla(1)), Arrays.asList(this.sla(1), this.sla(1902)), Arrays.asList(this.sla(1), this.sla(1902)));
    }

    @Test
    public void evolveClientFromNothingToSlaBackToNothing() {
        this.snapshots.slas(this.apiKey(), Arrays.asList(this.sla(1))).clients(this.apiKey(), Arrays.asList(this.platformContractAdapter(null))).clients(this.apiKey(), Arrays.asList(this.platformContractAdapter(1))).slas(this.apiKey(), Arrays.asList(this.sla(1), this.sla(1902))).clients(this.apiKey(), Arrays.asList(this.platformContractAdapter(1902))).slas(this.apiKey(), Arrays.asList(new Sla[0])).clients(this.apiKey(), Arrays.asList(this.platformContractAdapter(1))).slas(this.apiKey(), Arrays.asList(this.anotherSla(1)));
        this.checkContractsUpdatesAndMockedInvocations(EMPTY_UPDATE, Arrays.asList(this.noSlaContractForClient(1)), Arrays.asList(this.contractSingleLimit(1)), Arrays.asList(this.contractSingleLimit(1)), Arrays.asList(this.contractSingleLimit(1902)), Arrays.asList(this.contractSingleLimit(1902)), Arrays.asList(this.contractSingleLimit(1)), Arrays.asList(this.contract(this.anotherSla(1), this.client(1))));
        this.checkSlaUpdates(Arrays.asList(this.sla(1)), Arrays.asList(this.sla(1)), Arrays.asList(this.sla(1)), Arrays.asList(this.sla(1), this.sla(1902)), Arrays.asList(this.sla(1), this.sla(1902)), Arrays.asList(this.sla(1), this.sla(1902)), Arrays.asList(this.sla(1), this.sla(1902)), Arrays.asList(this.anotherSla(1), this.sla(1902)));
    }

    @Test
    public void tierChangesClient() {
        this.snapshots.slas(this.apiKey(), Arrays.asList(this.sla(1))).clients(this.apiKey(), Arrays.asList(this.platformContractAdapter(1))).clients(this.apiKey(), Arrays.asList(this.anotherPlatformContractAdapter(1)));
        this.checkContractsUpdatesAndMockedInvocations(EMPTY_UPDATE, Arrays.asList(this.contractSingleLimit(1)), Arrays.asList(this.contract(this.sla(1), this.anotherClient(1))));
        this.checkSlaUpdates(Arrays.asList(this.sla(1)), Arrays.asList(this.sla(1)), Arrays.asList(this.sla(1)));
    }

    @Test
    public void slasUsesLock() {
        this.snapshots.slas(this.apiKey(), Arrays.asList(new Sla[0]));
        ((Lock)Mockito.verify((Object)this.lock)).lock();
        ((Lock)Mockito.verify((Object)this.lock)).unlock();
    }

    @Test
    public void clientsUsesLock() {
        this.snapshots.clients(this.apiKey(), Arrays.asList(new PlatformContractAdapter[0]));
        ((Lock)Mockito.verify((Object)this.lock)).lock();
        ((Lock)Mockito.verify((Object)this.lock)).unlock();
    }

    @Test
    public void ifLockThrowsExceptionTiersClosureDoesNotRun() {
        BlowUpLock blowUpLock = new BlowUpLock();
        Runnable callTiers = () -> new ContractSnapshots(this.mocks.apiService(), (Lock)blowUpLock, (ClientFactory)new DefaultClientFactory()).slas(this.apiKey(), Arrays.asList(this.sla(1)));
        this.whenLockBlowsUpClosureIsNotExecuted(blowUpLock, callTiers);
    }

    @Test
    public void whenLockThrowsExceptionClientsClosureIsNotExecuted() {
        BlowUpLock blowUpLock = new BlowUpLock();
        Runnable callClients = () -> new ContractSnapshots(this.mocks.apiService(), (Lock)blowUpLock, (ClientFactory)new DefaultClientFactory()).clients(this.apiKey(), Arrays.asList(this.platformContractAdapter(1)));
        this.whenLockBlowsUpClosureIsNotExecuted(blowUpLock, callClients);
    }

    @Test
    public void sameClientChangingTiers() {
        this.snapshots.clients(this.apiKey(), Arrays.asList(this.platformContractAdapter(1))).slas(this.apiKey(), Arrays.asList(this.sla(1), this.sla(1902))).clients(this.apiKey(), Arrays.asList(this.platformContractAdapter(1902)));
        this.checkContractsUpdatesAndMockedInvocations(Arrays.asList(this.noSlaContractForClient(1)), Arrays.asList(this.contractSingleLimit(1)), Arrays.asList(this.contractSingleLimit(1902)));
        this.checkSlaUpdates(EMPTY_SLA_UPDATE, Arrays.asList(this.sla(1), this.sla(1902)), Arrays.asList(this.sla(1), this.sla(1902)));
    }

    @Test
    public void clientChangesTierAndTierAddedAfterwards() {
        this.snapshots.clients(this.apiKey(), Arrays.asList(this.platformContractAdapter(1))).slas(this.apiKey(), Arrays.asList(this.sla(1))).clients(this.apiKey(), Arrays.asList(this.platformContractAdapter(1902))).slas(this.apiKey(), Arrays.asList(this.sla(1902)));
        this.checkContractsUpdatesAndMockedInvocations(Arrays.asList(this.noSlaContractForClient(1)), Arrays.asList(this.contractSingleLimit(1)), Arrays.asList(this.noSlaContractForClient(1902)), Arrays.asList(this.contractSingleLimit(1902)));
        this.checkSlaUpdates(EMPTY_SLA_UPDATE, Arrays.asList(this.sla(1)), Arrays.asList(this.sla(1)), Arrays.asList(this.sla(1), this.sla(1902)));
    }

    @Test
    public void clientPollsUpdatesWithContractsWithNoTiers() {
        this.snapshots.clients(this.apiKey(), Arrays.asList(this.platformContractAdapter(null), this.anotherPlatformContractAdapter(1)));
        this.checkContractsUpdatesAndMockedInvocations(Arrays.asList(Contract.builder().withClient(this.client(null)).build(), this.noSlaContractForAnotherClient(1)));
        this.checkSlaUpdates(EMPTY_SLA_UPDATE);
    }

    @Test
    public void updateSlasForApiIsLogged() {
        TestLogger logger = TestLoggerFactory.getTestLogger(this.snapshots.getClass());
        this.snapshots.slas(this.apiKey(), Arrays.asList(this.sla(1)));
        MatcherAssert.assertThat((Object)logger.getAllLoggingEvents().size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)((LoggingEvent)logger.getAllLoggingEvents().get(0)), (Matcher)LogMatcher.logMatches((LoggingEvent)new LoggingEvent(Level.DEBUG, "Updating SLAs for API: {}", new Object[]{this.apiKey()})));
    }

    @Test
    public void updateContractsForApiIsLogged() {
        TestLogger logger = TestLoggerFactory.getTestLogger(this.snapshots.getClass());
        this.snapshots.clients(this.apiKey(), Arrays.asList(this.platformContractAdapter(1)));
        MatcherAssert.assertThat((Object)logger.getAllLoggingEvents().size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)((LoggingEvent)logger.getAllLoggingEvents().get(0)), (Matcher)LogMatcher.logMatches((LoggingEvent)new LoggingEvent(Level.DEBUG, "Updating Contracts for API: {}", new Object[]{this.apiKey()})));
    }

    private void whenLockBlowsUpClosureIsNotExecuted(BlowUpLock blowUpLock, Runnable closure) {
        boolean blowUpLockExploded = false;
        try {
            closure.run();
        }
        catch (RuntimeException e) {
            blowUpLockExploded = true;
        }
        if (!blowUpLockExploded) {
            Assert.fail((String)"Blow up lock didn't explode");
        }
        Mockito.verifyNoInteractions((Object[])new Object[]{this.mocks.apiTrackingService()});
        this.verifyApiTestInvocations();
        MatcherAssert.assertThat((Object)blowUpLock.isUnlockedCalled(), (Matcher)Matchers.is((Object)false));
    }

    private void checkContractsUpdatesAndMockedInvocations(List<Contract> ... expectedUpdates) {
        ((ApiService)Mockito.verify((Object)this.mocks.apiService(), (VerificationMode)Mockito.times((int)expectedUpdates.length))).getContracts((ApiKey)ArgumentMatchers.eq((Object)this.apiKey()));
        this.checkContractsUpdates(expectedUpdates);
        this.verifyApiTestInvocations();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mocks.apiTrackingService()});
    }

    private ApiKey apiKey() {
        return PolicyTestValuesConstants.API_KEY;
    }
}

