/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.deployment.platform.interaction.keepalive;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.mulesoft.mule.runtime.gw.api.config.GateKeeperConfiguration;
import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.mule.runtime.gw.api.policy.PolicyTemplateKey;
import com.mulesoft.mule.runtime.gw.client.dto.keepalive.KeepAliveDto;
import com.mulesoft.mule.runtime.gw.deployment.platform.interaction.keepalive.KeepAlivePayloadFactory;
import com.mulesoft.mule.runtime.gw.deployment.tracking.ApiTrackingService;
import com.mulesoft.mule.runtime.gw.model.Api;
import com.mulesoft.mule.runtime.gw.model.PolicyConfiguration;
import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;
import com.mulesoft.mule.runtime.gw.model.gatekeeper.status.GatekeeperStatus;
import com.mulesoft.mule.runtime.gw.policies.PolicyDefinitionDeploymentStatus;
import com.mulesoft.mule.runtime.gw.policies.PolicyDeploymentStatus;
import com.mulesoft.mule.runtime.gw.policies.service.PolicyDeploymentTracker;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNot;
import org.hamcrest.core.StringContains;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

public class KeepAlivePayloadFactoryTestCase {
    private static final ApiKey API_KEY = new ApiKey(Long.valueOf(1L));
    private static final PolicyTemplateKey TEMPLATE_KEY = new PolicyTemplateKey("group", "asset", "version");
    private final Api api = (Api)Mockito.mock(Api.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
    private final GateKeeperConfiguration gateKeeperConfiguration;
    private final ApiTrackingService apiTrackingService;
    private final PolicyDeploymentTracker policyDeploymentTracker;
    private final KeepAlivePayloadFactory factory;
    private final ObjectMapper objectMapper;

    public KeepAlivePayloadFactoryTestCase() {
        Mockito.when((Object)this.api.getKey()).thenReturn((Object)API_KEY);
        this.gateKeeperConfiguration = (GateKeeperConfiguration)Mockito.mock(GateKeeperConfiguration.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        this.apiTrackingService = (ApiTrackingService)Mockito.mock(ApiTrackingService.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        this.policyDeploymentTracker = (PolicyDeploymentTracker)Mockito.mock(PolicyDeploymentTracker.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        this.factory = new KeepAlivePayloadFactory(this.apiTrackingService, this.policyDeploymentTracker, this.gateKeeperConfiguration);
        this.objectMapper = new ObjectMapper().enable(DeserializationFeature.READ_ENUMS_USING_TO_STRING).enable(SerializationFeature.WRITE_ENUMS_USING_TO_STRING);
    }

    @Test
    public void gatekeeperStatus() throws IOException {
        Mockito.when((Object)this.policyDeploymentTracker.policyStatuses(API_KEY)).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.apiTrackingService.getTrackedApisRequiringContracts().contains(this.api)).thenReturn((Object)false);
        Mockito.when((Object)this.gateKeeperConfiguration.isEnabled()).thenReturn((Object)false);
        MatcherAssert.assertThat((Object)this.payload(), (Matcher)StringContains.containsString((String)"\"gatekeeper\":{\"blocked\":false,\"status\":\"DISABLED\"}"));
        Mockito.when((Object)this.gateKeeperConfiguration.isEnabled()).thenReturn((Object)true);
        Mockito.when((Object)this.api.getImplementation().gatekeeperStatus().status()).thenReturn((Object)GatekeeperStatus.READY);
        MatcherAssert.assertThat((Object)this.payload(), (Matcher)StringContains.containsString((String)"\"gatekeeper\":{\"blocked\":false,\"status\":\"READY\"}"));
        Mockito.when((Object)this.api.getImplementation().gatekeeperStatus().status()).thenReturn((Object)GatekeeperStatus.AWAITING_POLICIES);
        MatcherAssert.assertThat((Object)this.payload(), (Matcher)StringContains.containsString((String)"\"gatekeeper\":{\"blocked\":true,\"status\":\"AWAITING_POLICIES\"}"));
        Mockito.when((Object)this.api.getImplementation().gatekeeperStatus().status()).thenReturn((Object)GatekeeperStatus.POLICIES_FAILED);
        MatcherAssert.assertThat((Object)this.payload(), (Matcher)StringContains.containsString((String)"\"gatekeeper\":{\"blocked\":true,\"status\":\"POLICIES_FAILED\"}"));
        Mockito.when((Object)this.api.getImplementation().gatekeeperStatus().status()).thenReturn((Object)GatekeeperStatus.AWAITING_CONTRACTS);
        MatcherAssert.assertThat((Object)this.payload(), (Matcher)StringContains.containsString((String)"\"gatekeeper\":{\"blocked\":true,\"status\":\"AWAITING_CONTRACTS\"}"));
        Mockito.when((Object)this.api.getImplementation().gatekeeperStatus().status()).thenReturn((Object)GatekeeperStatus.AWAITING_UNBLOCK);
        MatcherAssert.assertThat((Object)this.payload(), (Matcher)StringContains.containsString((String)"\"gatekeeper\":{\"blocked\":true,\"status\":\"AWAITING_UNBLOCK\"}"));
        Mockito.when((Object)this.api.getImplementation().gatekeeperStatus().status()).thenReturn((Object)GatekeeperStatus.AWAITING_TRACKING);
        MatcherAssert.assertThat((Object)this.payload(), (Matcher)StringContains.containsString((String)"\"gatekeeper\":{\"blocked\":true,\"status\":\"AWAITING_TRACKING\"}"));
        Mockito.when((Object)this.api.getImplementation().gatekeeperStatus().status()).thenReturn((Object)GatekeeperStatus.UNTRACKED);
        MatcherAssert.assertThat((Object)this.payload(), (Matcher)StringContains.containsString((String)"\"gatekeeper\":{\"blocked\":true,\"status\":\"UNTRACKED\"}"));
    }

    @Test
    public void contractStatus() throws IOException {
        Mockito.when((Object)this.gateKeeperConfiguration.isEnabled()).thenReturn((Object)false);
        Mockito.when((Object)this.policyDeploymentTracker.policyStatuses(API_KEY)).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.apiTrackingService.getTrackedApisRequiringContracts().contains(this.api)).thenReturn((Object)false);
        MatcherAssert.assertThat((Object)this.payload(), (Matcher)IsNot.not((Matcher)StringContains.containsString((String)"\"contracts\"")));
        Mockito.when((Object)this.apiTrackingService.getTrackedApisRequiringContracts().contains(this.api)).thenReturn((Object)true);
        Mockito.when((Object)this.api.getTrackingInfo().getContractsEntityTag()).thenReturn(null);
        MatcherAssert.assertThat((Object)this.payload(), (Matcher)StringContains.containsString((String)"\"contracts\":\"\""));
        Mockito.when((Object)this.api.getTrackingInfo().getContractsEntityTag()).thenReturn((Object)"some");
        MatcherAssert.assertThat((Object)this.payload(), (Matcher)StringContains.containsString((String)"\"contracts\":\"some\""));
    }

    @Test
    public void policyStatus() throws IOException {
        Mockito.when((Object)this.gateKeeperConfiguration.isEnabled()).thenReturn((Object)false);
        Mockito.when((Object)this.apiTrackingService.getTrackedApisRequiringContracts().contains(this.api)).thenReturn((Object)false);
        Mockito.when((Object)this.policyDeploymentTracker.policyStatuses(API_KEY)).thenReturn(this.status(PolicyDefinitionDeploymentStatus.DeploymentStatus.DEPLOYMENT_FAILED));
        MatcherAssert.assertThat((Object)this.payload(), (Matcher)StringContains.containsString((String)"\"policies\":[{\"policyId\":\"1\",\"online\":true,\"targetVersion\":\"targetVersion\",\"currentVersion\":\"currentVersion\",\"status\":\"DEPLOYMENT_FAILED\"}]"));
        Mockito.when((Object)this.policyDeploymentTracker.policyStatuses(API_KEY)).thenReturn(this.status(PolicyDefinitionDeploymentStatus.DeploymentStatus.TEMPLATE_DOWNLOAD_FAILED));
        MatcherAssert.assertThat((Object)this.payload(), (Matcher)StringContains.containsString((String)"\"policies\":[{\"policyId\":\"1\",\"online\":true,\"targetVersion\":\"targetVersion\",\"currentVersion\":\"currentVersion\",\"status\":\"TEMPLATE_DOWNLOAD_FAILED\"}]"));
        Mockito.when((Object)this.policyDeploymentTracker.policyStatuses(API_KEY)).thenReturn(this.status(PolicyDefinitionDeploymentStatus.DeploymentStatus.REVERT_FAILED));
        MatcherAssert.assertThat((Object)this.payload(), (Matcher)StringContains.containsString((String)"\"policies\":[{\"policyId\":\"1\",\"online\":true,\"targetVersion\":\"targetVersion\",\"status\":\"REVERT_FAILED\"}]"));
        Mockito.when((Object)this.policyDeploymentTracker.policyStatuses(API_KEY)).thenReturn(this.status(PolicyDefinitionDeploymentStatus.DeploymentStatus.DEPLOYMENT_SUCCESS));
        MatcherAssert.assertThat((Object)this.payload(), (Matcher)StringContains.containsString((String)"\"policies\":[{\"policyId\":\"1\",\"online\":true,\"targetVersion\":\"targetVersion\",\"currentVersion\":\"targetVersion\",\"status\":\"DEPLOYMENT_SUCCESS\"}]"));
        Mockito.when((Object)this.policyDeploymentTracker.policyStatuses(API_KEY)).thenReturn(this.status(PolicyDefinitionDeploymentStatus.DeploymentStatus.DEPLOYMENT_SUCCESS, PolicyDefinitionDeploymentStatus.DeploymentStatus.DEPLOYMENT_SUCCESS));
        MatcherAssert.assertThat((Object)this.payload(), (Matcher)StringContains.containsString((String)"\"policies\":[{\"policyId\":\"1\",\"online\":true,\"targetVersion\":\"targetVersion\",\"currentVersion\":\"targetVersion\",\"status\":\"DEPLOYMENT_SUCCESS\"},{\"policyId\":\"2\",\"online\":true,\"targetVersion\":\"targetVersion\",\"currentVersion\":\"targetVersion\",\"status\":\"DEPLOYMENT_SUCCESS\"}]"));
    }

    @Test
    public void sameEtag() throws IOException {
        Mockito.when((Object)this.gateKeeperConfiguration.isEnabled()).thenReturn((Object)false);
        Mockito.when((Object)this.policyDeploymentTracker.policyStatuses(API_KEY)).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.apiTrackingService.getTrackedApisRequiringContracts().contains(this.api)).thenReturn((Object)false);
        KeepAliveDto payload = this.factory.create(this.api);
        MatcherAssert.assertThat((Object)this.factory.create(this.api).eTag(), (Matcher)Is.is((Object)payload.eTag()));
    }

    private String payload() throws IOException {
        return this.objectMapper.writeValueAsString((Object)this.factory.create(this.api));
    }

    private List<PolicyDeploymentStatus> status(PolicyDefinitionDeploymentStatus.DeploymentStatus ... statuses) {
        ArrayList<PolicyDeploymentStatus> result = new ArrayList<PolicyDeploymentStatus>();
        for (int i = 1; i <= statuses.length; ++i) {
            Optional<Object> current;
            PolicyDefinitionDeploymentStatus.DeploymentStatus targetStatus = statuses[i - 1];
            String id = Integer.toString(i);
            PolicyDefinition targetDef = new PolicyDefinition(id, "targetVersion", TEMPLATE_KEY, API_KEY, Collections.emptyList(), i, new PolicyConfiguration(Collections.emptyMap()));
            PolicyDefinitionDeploymentStatus target = new PolicyDefinitionDeploymentStatus(targetDef, targetStatus, null);
            switch (targetStatus) {
                case DEPLOYMENT_SUCCESS: {
                    current = Optional.of(target);
                    break;
                }
                case REVERT_FAILED: {
                    current = Optional.empty();
                    break;
                }
                default: {
                    PolicyDefinition currentDef = new PolicyDefinition(id, "currentVersion", TEMPLATE_KEY, API_KEY, Collections.emptyList(), i, new PolicyConfiguration(Collections.emptyMap()));
                    current = Optional.of(new PolicyDefinitionDeploymentStatus(currentDef, PolicyDefinitionDeploymentStatus.DeploymentStatus.DEPLOYMENT_SUCCESS, null));
                }
            }
            result.add(new PolicyDeploymentStatus(target, current));
        }
        return result;
    }
}

