/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.deployment.replication;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.mulesoft.anypoint.tests.PolicyTestValuesConstants;
import com.mulesoft.mule.runtime.gw.deployment.replication.StandaloneApiConfigurationCache;
import com.mulesoft.mule.runtime.gw.deployment.tracking.ApiTrackingService;
import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;
import com.mulesoft.mule.runtime.gw.model.PolicySet;
import com.mulesoft.mule.runtime.gw.model.contracts.repository.ContractRepository;
import com.mulesoft.mule.runtime.gw.policies.service.PolicySetDeploymentService;
import com.mulesoft.mule.runtime.gw.reflection.VariableOverride;
import java.util.HashMap;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.api.lifecycle.InitialisationException;

public class StandaloneApiConfigurationCacheTestCase {
    private PolicySetDeploymentService policySetDeploymentService;
    private ContractRepository contractRepository;
    private StandaloneApiConfigurationCache apiConfigurationCache;

    @Before
    public void setUp() {
        this.policySetDeploymentService = (PolicySetDeploymentService)Mockito.mock(PolicySetDeploymentService.class);
        this.contractRepository = (ContractRepository)Mockito.mock(ContractRepository.class);
        this.apiConfigurationCache = new StandaloneApiConfigurationCache(this.policySetDeploymentService);
        VariableOverride.overrideVariable((String)"contractRepository").in((Object)this.apiConfigurationCache).with((Object)this.contractRepository);
    }

    @Test
    public void getPolicySet() throws InitialisationException {
        PolicyDefinition policyDefinition = this.setDeploymentServiceWithPolicy();
        Optional policySet = this.initializeCache().getPolicies(PolicyTestValuesConstants.API_KEY);
        Assert.assertThat((Object)policySet.isPresent(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)((PolicySet)policySet.get()).isFromPlatform(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)((PolicySet)policySet.get()).getPolicyDefinitions(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)((PolicySet)policySet.get()).getPolicyDefinitions(), (Matcher)Matchers.hasItems((Object[])new PolicyDefinition[]{policyDefinition}));
    }

    @Test
    public void getEmptySet() throws InitialisationException {
        Mockito.when((Object)this.policySetDeploymentService.storedOnlinePoliciesByApi()).thenReturn(new HashMap());
        Mockito.when((Object)this.contractRepository.containsSla(PolicyTestValuesConstants.API_KEY)).thenReturn((Object)true);
        Optional policySet = this.initializeCache().getPolicies(PolicyTestValuesConstants.API_KEY);
        Assert.assertThat((Object)policySet.isPresent(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)((PolicySet)policySet.get()).isFromPlatform(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)((PolicySet)policySet.get()).getPolicyDefinitions(), (Matcher)Matchers.empty());
    }

    @Test
    public void getEmpty() throws InitialisationException {
        Mockito.when((Object)this.policySetDeploymentService.storedOnlinePoliciesByApi()).thenReturn(new HashMap());
        Mockito.when((Object)this.contractRepository.containsSla(PolicyTestValuesConstants.API_KEY)).thenReturn((Object)false);
        Optional policySet = this.initializeCache().getPolicies(PolicyTestValuesConstants.API_KEY);
        Assert.assertThat((Object)policySet.isPresent(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void remove() throws InitialisationException {
        this.setDeploymentServiceWithPolicy();
        this.initializeCache().remove(PolicyTestValuesConstants.API_KEY);
        Assert.assertThat((Object)this.apiConfigurationCache.getPolicies(PolicyTestValuesConstants.API_KEY), (Matcher)Matchers.is(Optional.empty()));
    }

    private StandaloneApiConfigurationCache initializeCache() {
        this.apiConfigurationCache.initialise((ApiTrackingService)Mockito.mock(ApiTrackingService.class));
        return this.apiConfigurationCache;
    }

    private PolicyDefinition setDeploymentServiceWithPolicy() {
        PolicyDefinition policyDefinition = (PolicyDefinition)Mockito.mock(PolicyDefinition.class);
        ImmutableMap storedPolicies = ImmutableMap.of((Object)PolicyTestValuesConstants.API_KEY, (Object)Lists.newArrayList((Object[])new PolicyDefinition[]{policyDefinition}));
        Mockito.when((Object)this.policySetDeploymentService.storedOnlinePoliciesByApi()).thenReturn((Object)storedPolicies);
        return policyDefinition;
    }
}

