/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.deployment.tracking;

import com.github.valfirst.slf4jtest.LoggingEvent;
import com.github.valfirst.slf4jtest.TestLogger;
import com.github.valfirst.slf4jtest.TestLoggerFactory;
import com.google.common.collect.Lists;
import com.mulesoft.anypoint.tests.PolicyTestValuesConstants;
import com.mulesoft.anypoint.tests.logger.LogMatcher;
import com.mulesoft.mule.runtime.gw.api.contract.Sla;
import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.mule.runtime.gw.client.exception.IncompatibleApiException;
import com.mulesoft.mule.runtime.gw.client.exception.NotFoundException;
import com.mulesoft.mule.runtime.gw.client.model.ApiResponse;
import com.mulesoft.mule.runtime.gw.client.session.ApiPlatformSession;
import com.mulesoft.mule.runtime.gw.client.session.factory.ApiPlatformSessionFactory;
import com.mulesoft.mule.runtime.gw.deployment.tracking.ApiTracker;
import com.mulesoft.mule.runtime.gw.deployment.tracking.ApiTrackingService;
import com.mulesoft.mule.runtime.gw.model.Api;
import com.mulesoft.mule.runtime.gw.model.ApiImplementation;
import com.mulesoft.mule.runtime.gw.model.PolicySet;
import com.mulesoft.mule.runtime.gw.model.TrackingInfo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.rule.LogCleanup;
import uk.org.lidalia.slf4jext.Level;

@RunWith(value=MockitoJUnitRunner.class)
public class ApiTrackerTestCase
extends AbstractMuleTestCase {
    @Rule
    public TestRule chain = RuleChain.outerRule((TestRule)new LogCleanup());
    @Mock
    private ApiTrackingService apiTrackingService;
    @Mock
    private ApiPlatformSessionFactory sessionFactory;
    @Mock
    private ApiPlatformSession session;
    @Mock
    private ApiImplementation implementation;
    @Mock
    private Api api;
    private ApiTracker apiTracker;
    private TestLogger logger;

    @Before
    public void setUp() {
        this.apiTracker = new ApiTracker(this.apiTrackingService, this.sessionFactory);
        Mockito.when((Object)this.sessionFactory.create()).thenReturn((Object)this.session);
        Mockito.when((Object)this.implementation.getApiKey()).thenReturn((Object)PolicyTestValuesConstants.API_KEY);
        Mockito.when((Object)this.api.getImplementation()).thenReturn((Object)this.implementation);
        this.logger = TestLoggerFactory.getTestLogger(ApiTracker.class);
    }

    @Test
    public void success() {
        TrackingInfo trackingInfo = (TrackingInfo)Mockito.mock(TrackingInfo.class);
        PolicySet policySet = (PolicySet)Mockito.mock(PolicySet.class);
        ArrayList slas = Lists.newArrayList((Object[])new Sla[]{(Sla)Mockito.mock(Sla.class)});
        ApiResponse apiResponse = new ApiResponse(trackingInfo, policySet, (List)slas, true);
        Mockito.when((Object)this.session.getApi((ApiKey)ArgumentMatchers.any(ApiKey.class))).thenReturn((Object)apiResponse);
        this.apiTracker.onApiDeploymentSuccess(this.api);
        ((ApiTrackingService)Mockito.verify((Object)this.apiTrackingService)).apiTracked(PolicyTestValuesConstants.API_KEY, trackingInfo, policySet, (List)slas);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.apiTrackingService});
    }

    @Test
    public void incompatibleApi() throws IOException {
        IncompatibleApiException exception = new IncompatibleApiException("");
        Mockito.when((Object)this.session.getApi((ApiKey)ArgumentMatchers.any(ApiKey.class))).thenThrow(new Throwable[]{exception});
        this.apiTracker.onApiDeploymentSuccess(this.api);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.apiTrackingService});
        MatcherAssert.assertThat((Object)this.logger.getAllLoggingEvents(), (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat((Object)((LoggingEvent)this.logger.getAllLoggingEvents().get(1)), (Matcher)LogMatcher.logMatches((LoggingEvent)new LoggingEvent(Level.ERROR, "There was an error trying to track API {}. {}", new Object[]{1L, "Reason: " + exception})));
    }

    @Test
    public void apiNotFound() {
        Mockito.when((Object)this.session.getApi(PolicyTestValuesConstants.API_KEY)).thenThrow(new Throwable[]{new NotFoundException("")});
        this.apiTracker.onApiDeploymentSuccess(this.api);
        ((ApiTrackingService)Mockito.verify((Object)this.apiTrackingService)).apiUntracked(PolicyTestValuesConstants.API_KEY);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.apiTrackingService});
    }

    @Test
    public void errorIsCorrectlyLogged() {
        Mockito.when((Object)this.session.getApi(PolicyTestValuesConstants.API_KEY)).thenThrow(new Throwable[]{new InternalError()});
        try {
            this.apiTracker.onApiDeploymentSuccess(this.api);
            Assert.fail();
        }
        catch (InternalError internalError) {
            // empty catch block
        }
        ((ApiTrackingService)Mockito.verify((Object)this.apiTrackingService)).apiTrackingFailed(PolicyTestValuesConstants.API_KEY);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.apiTrackingService});
        MatcherAssert.assertThat((Object)this.logger.getAllLoggingEvents(), (Matcher)Matchers.hasSize((int)3));
        MatcherAssert.assertThat((Object)((LoggingEvent)this.logger.getAllLoggingEvents().get(1)), (Matcher)LogMatcher.logMatches((LoggingEvent)new LoggingEvent(Level.ERROR, "Failed to {} '{}'. {}", new Object[]{"retrieve API information for API", 1L, "Reason: java.lang.InternalError: null"})));
    }
}

