/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.deployment;

import com.mulesoft.anypoint.backoff.configuration.BackoffConfigurationSupplier;
import com.mulesoft.anypoint.backoff.scheduler.factory.BackoffSchedulerFactory;
import com.mulesoft.anypoint.backoff.scheduler.factory.VariableExecutorBackoffSchedulerFactory;
import com.mulesoft.mule.runtime.gw.api.ApiContractsSupplier;
import com.mulesoft.mule.runtime.gw.api.agent.GatewayCoreExtension;
import com.mulesoft.mule.runtime.gw.api.agent.HealthCheck;
import com.mulesoft.mule.runtime.gw.api.config.GatewayConfiguration;
import com.mulesoft.mule.runtime.gw.api.config.GatewaySecurityConfiguration;
import com.mulesoft.mule.runtime.gw.api.logging.ExceptionDescriptor;
import com.mulesoft.mule.runtime.gw.api.service.ApiContractsPrefetch;
import com.mulesoft.mule.runtime.gw.api.service.ContractService;
import com.mulesoft.mule.runtime.gw.autodiscovery.ApiDiscovery;
import com.mulesoft.mule.runtime.gw.client.ApiPlatformClient;
import com.mulesoft.mule.runtime.gw.client.provider.ApiPlatformClientProvider;
import com.mulesoft.mule.runtime.gw.config.AnalyticsConfiguration;
import com.mulesoft.mule.runtime.gw.deployment.OfflineModeApiDeploymentListener;
import com.mulesoft.mule.runtime.gw.deployment.api.ApiService;
import com.mulesoft.mule.runtime.gw.deployment.contracts.ContractSnapshots;
import com.mulesoft.mule.runtime.gw.deployment.platform.interaction.PlatformInteractionServicesLifecycle;
import com.mulesoft.mule.runtime.gw.deployment.platform.interaction.PlatformInteractionServicesLifecycleFactory;
import com.mulesoft.mule.runtime.gw.deployment.quorum.ClusterReadyRetrier;
import com.mulesoft.mule.runtime.gw.deployment.replication.ApiConfigurationCache;
import com.mulesoft.mule.runtime.gw.deployment.replication.DistributedApiConfigurationCache;
import com.mulesoft.mule.runtime.gw.deployment.replication.StandaloneApiConfigurationCache;
import com.mulesoft.mule.runtime.gw.deployment.service.CoreServicesClientsRepository;
import com.mulesoft.mule.runtime.gw.deployment.service.DefaultApiService;
import com.mulesoft.mule.runtime.gw.deployment.tracking.ApiTrackingService;
import com.mulesoft.mule.runtime.gw.deployment.tracking.DefaultApiTrackingService;
import com.mulesoft.mule.runtime.gw.deployment.type.DeploymentTarget;
import com.mulesoft.mule.runtime.gw.extension.GatewayEntitledCoreExtension;
import com.mulesoft.mule.runtime.gw.hdp.listener.HdpDeploymentListener;
import com.mulesoft.mule.runtime.gw.internal.encryption.RuntimeEncrypterFactory;
import com.mulesoft.mule.runtime.gw.logging.LoggingClassLoaderSelector;
import com.mulesoft.mule.runtime.gw.logging.OneTimeWarning;
import com.mulesoft.mule.runtime.gw.metrics.GatewayMetricsAdapter;
import com.mulesoft.mule.runtime.gw.metrics.GatewayMetricsFactory;
import com.mulesoft.mule.runtime.gw.model.contracts.ClientFactory;
import com.mulesoft.mule.runtime.gw.model.contracts.DefaultClientFactory;
import com.mulesoft.mule.runtime.gw.model.contracts.HashedClientFactory;
import com.mulesoft.mule.runtime.gw.model.contracts.repository.ContractRepository;
import com.mulesoft.mule.runtime.gw.model.contracts.repository.MapDBContractRepository;
import com.mulesoft.mule.runtime.gw.notification.ApiContractsListener;
import com.mulesoft.mule.runtime.gw.notification.ApiDeploymentListener;
import com.mulesoft.mule.runtime.gw.policies.deployment.DefaultPolicyDeployer;
import com.mulesoft.mule.runtime.gw.policies.deployment.PolicyDeployer;
import com.mulesoft.mule.runtime.gw.policies.encryption.DefaultPolicyConfigurationEncrypter;
import com.mulesoft.mule.runtime.gw.policies.encryption.PolicyConfigurationEncrypter;
import com.mulesoft.mule.runtime.gw.policies.factory.DefaultPolicyFactory;
import com.mulesoft.mule.runtime.gw.policies.factory.EncryptedPolicyFactory;
import com.mulesoft.mule.runtime.gw.policies.factory.PolicyConfigurationSanitizer;
import com.mulesoft.mule.runtime.gw.policies.factory.PolicyFactory;
import com.mulesoft.mule.runtime.gw.policies.factory.PolicyParametrizationFactory;
import com.mulesoft.mule.runtime.gw.policies.lifecyle.DefaultHealthCheck;
import com.mulesoft.mule.runtime.gw.policies.lifecyle.GateKeeperSupplier;
import com.mulesoft.mule.runtime.gw.policies.lifecyle.HdpApisHealthCheckListener;
import com.mulesoft.mule.runtime.gw.policies.lifecyle.PolicySetDeploymentListener;
import com.mulesoft.mule.runtime.gw.policies.notification.PolicyNotificationListenerSuppliers;
import com.mulesoft.mule.runtime.gw.policies.offline.OfflinePolicyWatcher;
import com.mulesoft.mule.runtime.gw.policies.service.DefaultMultiplexingPolicyDeploymentService;
import com.mulesoft.mule.runtime.gw.policies.service.DefaultPolicyDeploymentTracker;
import com.mulesoft.mule.runtime.gw.policies.service.DefaultPolicySetDeploymentService;
import com.mulesoft.mule.runtime.gw.policies.service.DefaultTransactionalPolicyDeploymentService;
import com.mulesoft.mule.runtime.gw.policies.service.MultiplexingPolicyDeploymentService;
import com.mulesoft.mule.runtime.gw.policies.service.PolicyDeploymentTracker;
import com.mulesoft.mule.runtime.gw.policies.service.PolicySetDeploymentService;
import com.mulesoft.mule.runtime.gw.policies.service.TransactionalPolicyDeploymentService;
import com.mulesoft.mule.runtime.gw.policies.store.DefaultPolicyStore;
import com.mulesoft.mule.runtime.gw.policies.store.EncryptedPropertiesSerializer;
import com.mulesoft.mule.runtime.gw.policies.store.PolicyStore;
import com.mulesoft.mule.runtime.gw.policies.store.PolicyTemplateStore;
import com.mulesoft.mule.runtime.gw.policies.template.provider.FileSystemPolicyTemplateProvider;
import com.mulesoft.mule.runtime.gw.policies.template.provider.GatewayPolicyTemplateDescriptorFactory;
import com.mulesoft.mule.runtime.gw.policies.template.provider.PolicyTemplateProvider;
import com.mulesoft.mule.runtime.gw.policies.template.resolver.HandlebarsPolicyTemplateResolver;
import com.mulesoft.mule.runtime.gw.policies.template.resolver.PolicyTemplateResolver;
import com.mulesoft.mule.runtime.gw.retry.BackoffRunnableRetrierFactory;
import com.mulesoft.mule.runtime.module.cluster.api.ClusterCoreExtension;
import com.mulesoft.mule.runtime.module.cluster.api.notification.PrimaryClusterNodeListener;
import java.util.HashMap;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import javax.inject.Inject;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.config.custom.CustomizationService;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.healthcheck.HealthCheckValidator;
import org.mule.runtime.api.healthcheck.ReadyStatus;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lock.LockFactory;
import org.mule.runtime.container.api.MuleCoreExtensionDependency;
import org.mule.runtime.core.api.config.MuleManifest;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.module.deployment.api.DeploymentListener;
import org.mule.runtime.module.deployment.api.DeploymentService;
import org.mule.runtime.module.deployment.api.StartupListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiDeploymentCoreExtension
extends GatewayEntitledCoreExtension
implements GatewayCoreExtension,
PrimaryClusterNodeListener,
StartupListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApiDeploymentCoreExtension.class);
    private static final String AGW_HEALTHCHECK_HOLDER = "agw-healthcheck-holder";
    private final long startTime = System.currentTimeMillis();
    private final GatewayConfiguration configuration;
    private final ApiPlatformClientProvider clientProvider;
    private final BackoffConfigurationSupplier backoffConfigurationSupplier;
    private final OneTimeWarning missingClientCredentialErrorWarn;
    private final BackoffRunnableRetrierFactory backoffRunnableRetrierFactory;
    private final Object lock = new Object();
    private final AtomicBoolean clusterReady = new AtomicBoolean();
    private final AtomicBoolean primaryNodeMarked = new AtomicBoolean();
    private ApiDiscovery apiDiscovery;
    @Inject
    private ContractService contractService;
    @Inject
    private DeploymentService deploymentService;
    private LockFactory lockFactory;
    private ClusterCoreExtension clusterCoreExtension;
    private OfflinePolicyWatcher offlinePolicyWatcher;
    private ApiPlatformClient restClient;
    private PolicyNotificationListenerSuppliers notificationListenerSuppliers;
    private ApiService apiService;
    private HdpDeploymentListener hdpDeploymentListener;
    private ApiTrackingService apiTrackingService;
    private ApiConfigurationCache apiConfigurationCache;
    private ContractSnapshots contractSnapshots;
    private PlatformInteractionServicesLifecycle platformInteractionServicesLifecycle;
    private ApiDeploymentListener offlineModeDeploymentListener;
    private PolicySetDeploymentService policySetDeploymentService;
    private HealthCheck healthCheck;
    private boolean extensionInitialized;
    private boolean restClientInitialized;
    private Optional<GatewayMetricsAdapter> metricsCollector = Optional.empty();
    private ClusterReadyRetrier clusterReadyRetrier;

    public ApiDeploymentCoreExtension() {
        this.configuration = new GatewayConfiguration();
        this.backoffConfigurationSupplier = new BackoffConfigurationSupplier();
        this.backoffRunnableRetrierFactory = new BackoffRunnableRetrierFactory(this.configuration);
        this.clientProvider = new ApiPlatformClientProvider(this.backoffRunnableRetrierFactory.platformConnectionRetrier());
        this.missingClientCredentialErrorWarn = new OneTimeWarning(LOGGER, "Client ID or Client Secret were not provided. API Platform client is DISABLED.");
    }

    public void initialiseCoreExtension() {
        this.apiDiscovery = new ApiDiscovery();
        this.notificationListenerSuppliers = new PolicyNotificationListenerSuppliers();
        this.apiService = new DefaultApiService(this.deploymentService);
        this.hdpDeploymentListener = new HdpDeploymentListener(this.apiService, this.deploymentService);
        this.clusterReadyRetrier = new ClusterReadyRetrier(this.configuration.quorum(), this.lockFactory);
    }

    public String getName() {
        return "API Gateway Extension";
    }

    public ApiPlatformClient apiPlatformClient() {
        return this.clientProvider.getClient();
    }

    public synchronized void finishLazyInitialization() {
        if (!this.extensionInitialized) {
            this.finishCoreExtensionInitialization();
            this.startCoreExtension();
            this.extensionInitialized = true;
        }
    }

    public void finishCoreExtensionInitialization() {
        this.clusterCoreExtension.registerPrimaryNodeListener((PrimaryClusterNodeListener)this);
        LOGGER.info("Starting {} in {} mode", (Object)this.getName(), (Object)(this.isCluster() ? "CLUSTERED" : "STANDALONE"));
        if (this.configuration.platformClient().isOnPrem().booleanValue()) {
            LOGGER.info("Running in On Prem mode.");
        }
        if (this.configuration.securityConfiguration().isEncryptionEnabled()) {
            LOGGER.debug("An encryption key is present. Policies and API contracts will be encrypted");
        } else {
            LOGGER.debug("No encryption key provided. Policies and API contracts won't be encrypted");
        }
        this.restClient = this.clientProvider.getClient();
        this.contractService.contractSupplier((ApiContractsSupplier)this.apiService);
        this.contractService.contractPrefetch((ApiContractsPrefetch)this.apiService);
        DefaultPolicyDeploymentTracker policyDeploymentTracker = new DefaultPolicyDeploymentTracker();
        DefaultPolicyStore policyStore = new DefaultPolicyStore(new EncryptedPropertiesSerializer());
        DefaultMultiplexingPolicyDeploymentService policyDeploymentService = new DefaultMultiplexingPolicyDeploymentService(this.apiService, (PolicyDeploymentTracker)policyDeploymentTracker, (TransactionalPolicyDeploymentService)new DefaultTransactionalPolicyDeploymentService((PolicyDeploymentTracker)policyDeploymentTracker, (PolicyStore)policyStore, this.getPolicyFactory(), (PolicyDeployer)new DefaultPolicyDeployer((PolicyStore)policyStore, this.notificationListenerSuppliers, new PolicyParametrizationFactory())));
        this.policySetDeploymentService = new DefaultPolicySetDeploymentService(this.backoffRunnableRetrierFactory.policySetDeploymentServiceRetrier(), (MultiplexingPolicyDeploymentService)policyDeploymentService, (PolicyDeploymentTracker)policyDeploymentTracker, (PolicyStore)policyStore, new PolicyTemplateStore(), this.apiService);
        this.offlinePolicyWatcher = new OfflinePolicyWatcher((MultiplexingPolicyDeploymentService)policyDeploymentService);
        this.contractSnapshots = new ContractSnapshots(this.apiService, new ReentrantLock(), this.getClientFactory());
        this.apiConfigurationCache = this.isCluster() ? new DistributedApiConfigurationCache(this.apiService, this.policySetDeploymentService, this.contractSnapshots, this.lockFactory, this.clusterCoreExtension.getClusterManager(), (ContractRepository)new MapDBContractRepository()) : new StandaloneApiConfigurationCache(this.policySetDeploymentService);
        this.offlineModeDeploymentListener = new OfflineModeApiDeploymentListener(this.apiConfigurationCache, this.policySetDeploymentService);
        this.apiTrackingService = new DefaultApiTrackingService(this.apiService, this.policySetDeploymentService, this.apiConfigurationCache, this.contractSnapshots, this.contractService, this.configuration.onApiDeletedConfiguration());
        HdpApisHealthCheckListener hdpApisHealthCheckListener = new HdpApisHealthCheckListener(this.apiService);
        this.policySetDeploymentService.addPolicyDeploymentListener((PolicySetDeploymentListener)hdpApisHealthCheckListener);
        this.apiService.addApiContractsListener((ApiContractsListener)hdpApisHealthCheckListener);
        this.apiService.addDeploymentListener((ApiDeploymentListener)hdpApisHealthCheckListener);
        this.deploymentService.addDeploymentListener((DeploymentListener)this.apiService);
        this.deploymentService.addDeploymentListener((DeploymentListener)this.hdpDeploymentListener);
        this.apiService.addDeploymentListener((ApiDeploymentListener)this.policySetDeploymentService);
        this.apiService.addDeploymentListener(this.offlineModeDeploymentListener);
        this.metricsCollector = new GatewayMetricsFactory().from(this.restClient, this.configuration, this.deploymentService, this.apiService, (PolicyDeploymentTracker)policyDeploymentTracker);
        this.collectGatewayMetrics();
        this.healthCheck = new DefaultHealthCheck(this.apiService);
        if (this.configuration.platformClient().deleteUnusedTemplatesOnStart().booleanValue()) {
            try {
                LOGGER.debug("Deleting policy templates not in use");
                this.policySetDeploymentService.cleanUnusedTemplates();
            }
            catch (Exception e) {
                LOGGER.warn("Unexpected error deleting policy templates not in use", (Throwable)e);
            }
        }
        this.offlinePolicyWatcher.initialise();
    }

    public void startCoreExtension() {
        this.deploymentService.addStartupListener((StartupListener)this);
        try {
            this.offlinePolicyWatcher.start();
        }
        catch (Exception e) {
            LOGGER.error("An unexpected exception was raised when loading in Gateway Pollers Core Extension. {}", (Object)ExceptionDescriptor.errorMessage((Throwable)e));
        }
        new GateKeeperSupplier(this.configuration.gateKeeper(), this.apiService).get().ifPresent(gateKeeper -> {
            this.policySetDeploymentService.addPolicyDeploymentListener((PolicySetDeploymentListener)gateKeeper);
            this.apiService.addApiContractsListener((ApiContractsListener)gateKeeper);
            this.apiService.addDeploymentListener((ApiDeploymentListener)gateKeeper);
        });
        this.platformInteractionServicesLifecycle = new PlatformInteractionServicesLifecycleFactory().create(this.apiService, this.apiTrackingService, this.clientProvider, (BackoffSchedulerFactory)new VariableExecutorBackoffSchedulerFactory(), this.backoffConfigurationSupplier, this.backoffRunnableRetrierFactory, !this.isCluster());
        if (this.isCluster()) {
            this.clusterReadyRetrier.deferTillClusterReady(this::onClusterReady);
        } else {
            this.apiConfigurationCache.initialise(this.apiTrackingService);
            this.initialiseRestClient();
        }
    }

    public void onClusterReady() {
        LOGGER.debug("Cluster is ready, finishing initialization...");
        this.apiConfigurationCache.initialise(this.apiTrackingService);
        this.clusterReady.set(true);
        if (this.clusterCoreExtension.getClusterManager().isPrimaryPollingInstance()) {
            this.onNotification();
        }
        this.initialiseRestClient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNotification() {
        Object object = this.lock;
        synchronized (object) {
            if (this.clusterReady.get() && !this.primaryNodeMarked.get()) {
                LOGGER.info("We have become the primary cluster node. Starting API Manager runnables");
                this.platformInteractionServicesLifecycle.primaryNode();
                this.primaryNodeMarked.set(true);
            }
        }
    }

    public void onArtifactCreated(String artifactName, CustomizationService customizationService) {
        LoggingClassLoaderSelector.initialise((ClassLoader)Thread.currentThread().getContextClassLoader());
        ClassUtils.withContextClassLoader((ClassLoader)this.containerClassLoader.getClassLoader(), () -> {
            if (this.extensionLoaded()) {
                customizationService.registerCustomServiceImpl("api-deployment-initialization", (Object)new ExtensionInitialisation(this));
                if (this.onlineMode()) {
                    customizationService.registerCustomServiceImpl("clients-repository", (Object)new CoreServicesClientsRepository(this.clientProvider.getClient(), this.configuration.platformClient().legacyProviderEnabled()));
                }
                customizationService.registerCustomServiceImpl("hdp-apis-healthcheck", new HashMap());
            }
            customizationService.registerCustomServiceImpl(AGW_HEALTHCHECK_HOLDER, (Object)new HealthCheckValidatorHolder(this, artifactName));
            LOGGER.debug("HealthCheckValidatorHolder registered for application " + artifactName);
        });
    }

    public void start() {
    }

    public void stop() throws MuleException {
        this.removeSecretsFromSystem();
        this.clientProvider.shutdown();
        if (this.offlinePolicyWatcher != null) {
            this.offlinePolicyWatcher.stop();
        }
    }

    public void dispose() {
        this.metricsCollector.ifPresent(GatewayMetricsAdapter::dispose);
        if (this.platformInteractionServicesLifecycle != null) {
            this.platformInteractionServicesLifecycle.dispose();
        }
        if (this.offlinePolicyWatcher != null) {
            this.offlinePolicyWatcher.dispose();
        }
        this.backoffRunnableRetrierFactory.dispose();
        LoggingClassLoaderSelector.dispose();
        this.clusterReadyRetrier.dispose();
    }

    public void onAfterStartup() {
        if (LOGGER.isDebugEnabled()) {
            long elapsedTime = System.currentTimeMillis() - this.startTime;
            LOGGER.debug("-= All applications started (took " + elapsedTime + "ms)");
        }
    }

    @MuleCoreExtensionDependency
    public void setClusterCoreExtension(ClusterCoreExtension clusterCoreExtension) {
        this.clusterCoreExtension = clusterCoreExtension;
    }

    @Inject
    public void setLockFactory(LockFactory factory) {
        this.lockFactory = factory;
    }

    public ApiService getApiService() {
        return this.apiService;
    }

    public PolicyNotificationListenerSuppliers getNotificationListenerSuppliers() {
        return this.notificationListenerSuppliers;
    }

    public HealthCheck healthCheck() {
        return this.healthCheck;
    }

    public Optional<GatewayMetricsAdapter> metricsCollector() {
        return this.metricsCollector;
    }

    void initialiseRestClient() {
        if (!this.restClientInitialized) {
            if (this.onlineMode()) {
                if (this.clientProvider.configureClient(this.configuration)) {
                    this.clientProvider.addConnectionListener(() -> this.apiService.removeDeploymentListener(this.offlineModeDeploymentListener));
                    this.metricsCollector.ifPresent(arg_0 -> ((ApiPlatformClientProvider)this.clientProvider).addConnectionListener(arg_0));
                    this.clientProvider.connectClient();
                    this.restClientInitialized = true;
                }
            } else {
                this.missingClientCredentialErrorWarn.warn();
            }
        }
    }

    private void collectGatewayMetrics() {
        this.metricsCollector.ifPresent(gatewayMetricsAdapter -> gatewayMetricsAdapter.gatewayInformation(MuleManifest.getProductVersion(), DeploymentTarget.getDeploymentTarget(), this.isCluster(), this.configuration, new AnalyticsConfiguration()));
    }

    private boolean isCluster() {
        return this.clusterCoreExtension.getClusterManager() != null;
    }

    private void removeSecretsFromSystem() {
        this.configuration.platformClient().clearClientSecret();
        this.configuration.securityConfiguration().clearEncryptionKey();
    }

    private PolicyFactory getPolicyFactory() {
        HandlebarsPolicyTemplateResolver templateResolver = new HandlebarsPolicyTemplateResolver();
        GatewayPolicyTemplateDescriptorFactory policyTemplateDescriptorFactory = new GatewayPolicyTemplateDescriptorFactory();
        FileSystemPolicyTemplateProvider templateProvider = new FileSystemPolicyTemplateProvider(this.restClient, policyTemplateDescriptorFactory, new PolicyTemplateStore());
        PolicyConfigurationSanitizer sanitizer = new PolicyConfigurationSanitizer(this.configuration.platformServices().getValidateSchemas());
        return this.configuration.securityConfiguration().isEncryptionEnabled() ? new EncryptedPolicyFactory((PolicyTemplateResolver)templateResolver, (PolicyTemplateProvider)templateProvider, (PolicyConfigurationEncrypter)new DefaultPolicyConfigurationEncrypter(RuntimeEncrypterFactory.createDefaultRuntimeEncrypter(), this.configuration.securityConfiguration().isSensitiveOnlyEncryption()), sanitizer) : new DefaultPolicyFactory((PolicyTemplateResolver)templateResolver, (PolicyTemplateProvider)templateProvider, sanitizer);
    }

    private ClientFactory getClientFactory() {
        GatewaySecurityConfiguration gatewaySecurityConfiguration = this.configuration.securityConfiguration();
        if (gatewaySecurityConfiguration.hashClients()) {
            String hashAlgorithm = gatewaySecurityConfiguration.hashAlgorithm();
            LOGGER.debug("API Gateway initializing with Client Hashing algorithm: {}", (Object)hashAlgorithm);
            return new HashedClientFactory(hashAlgorithm);
        }
        return new DefaultClientFactory();
    }

    private static class HealthCheckValidatorHolder
    implements HealthCheckValidator {
        private ApiDeploymentCoreExtension apiDeploymentCoreExtension;
        private String artifactName;
        private HealthCheckValidator validator;

        public HealthCheckValidatorHolder(ApiDeploymentCoreExtension apiDeploymentCoreExtension, String artifactName) {
            this.apiDeploymentCoreExtension = apiDeploymentCoreExtension;
            this.artifactName = artifactName;
        }

        void set(HealthCheck healthCheck) {
            LOGGER.debug("HealthCheckValidatorHolder initialized for application " + this.artifactName);
            this.validator = healthCheck.getValidator(this.artifactName);
        }

        public ReadyStatus ready() {
            if (this.validator != null) {
                return this.validator.ready();
            }
            return () -> true;
        }
    }

    class ExtensionInitialisation
    implements Initialisable {
        private ApiDeploymentCoreExtension apiDeploymentCoreExtension;
        @Inject
        private Registry registry;

        public ExtensionInitialisation(ApiDeploymentCoreExtension apiDeploymentCoreExtension) {
            this.apiDeploymentCoreExtension = apiDeploymentCoreExtension;
        }

        public void initialise() {
            ClassUtils.withContextClassLoader((ClassLoader)ApiDeploymentCoreExtension.this.containerClassLoader.getClassLoader(), () -> {
                if (ApiDeploymentCoreExtension.this.onlineMode() || !ApiDeploymentCoreExtension.this.apiDiscovery.apiKeys(this.registry).isEmpty()) {
                    this.apiDeploymentCoreExtension.finishLazyInitialization();
                }
                if (!ApiDeploymentCoreExtension.this.apiDiscovery.apiKeys(this.registry).isEmpty()) {
                    this.registry.lookupByName(ApiDeploymentCoreExtension.AGW_HEALTHCHECK_HOLDER).ifPresent(h -> ((HealthCheckValidatorHolder)h).set(ApiDeploymentCoreExtension.this.healthCheck));
                }
            });
        }
    }
}

