/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.deployment.replication;

import com.github.valfirst.slf4jtest.LoggingEvent;
import com.github.valfirst.slf4jtest.TestLogger;
import com.github.valfirst.slf4jtest.TestLoggerFactory;
import com.mulesoft.anypoint.tests.PolicyTestValuesConstants;
import com.mulesoft.anypoint.tests.logger.LogMatcher;
import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.mule.runtime.gw.deployment.api.ApiService;
import com.mulesoft.mule.runtime.gw.deployment.contracts.ContractSnapshots;
import com.mulesoft.mule.runtime.gw.deployment.replication.DistributedApiConfigurationEntry;
import com.mulesoft.mule.runtime.gw.deployment.replication.DistributedPoliciesMapEntryListener;
import com.mulesoft.mule.runtime.gw.deployment.tracking.ApiTrackingService;
import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;
import com.mulesoft.mule.runtime.gw.model.PolicySet;
import com.mulesoft.mule.runtime.gw.policies.service.PolicySetDeploymentService;
import com.mulesoft.mule.runtime.module.cluster.api.map.EntryEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.mule.tck.junit4.rule.LogCleanup;
import uk.org.lidalia.slf4jext.Level;

public class DistributedPoliciesMapEntryListenerTestCase {
    @Rule
    public TestRule chain = RuleChain.outerRule((TestRule)new LogCleanup());
    private static final int OVERRIDDEN_HASHCODE = 1902;
    private DistributedPoliciesMapEntryListener entryListener;
    private TestLogger logger;
    private ApiService apiService;
    private ApiTrackingService apiTrackingService;
    private ContractSnapshots contractSnapshots;
    private PolicyDefinition policyDefinition;
    private PolicySetDeploymentService policySetDeploymentService;

    @Before
    public void setUp() {
        this.apiService = (ApiService)Mockito.mock(ApiService.class);
        this.policySetDeploymentService = (PolicySetDeploymentService)Mockito.mock(PolicySetDeploymentService.class);
        this.contractSnapshots = (ContractSnapshots)Mockito.mock(ContractSnapshots.class);
        this.logger = TestLoggerFactory.getTestLogger(DistributedPoliciesMapEntryListener.class);
        this.policyDefinition = (PolicyDefinition)Mockito.mock(PolicyDefinition.class);
        this.apiTrackingService = (ApiTrackingService)Mockito.mock(ApiTrackingService.class);
        this.entryListener = new DistributedPoliciesMapEntryListener(this.apiService, this.apiTrackingService, this.policySetDeploymentService, this.contractSnapshots, false);
    }

    @Test
    public void entryAddedLocalMember() {
        EntryEvent<String, DistributedApiConfigurationEntry> entry = this.mockEntry(true);
        this.entryListener.entryAdded(entry);
        this.verifyNoServiceInteractions();
        MatcherAssert.assertThat((Object)this.logger.getAllLoggingEvents(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)((LoggingEvent)this.logger.getAllLoggingEvents().get(0)), (Matcher)LogMatcher.logMatches((LoggingEvent)this.entryAddedDebugLine()));
    }

    @Test
    public void deployApiEntryAddedNonLocalMember() {
        Mockito.when((Object)this.apiService.isDeployed((ApiKey)ArgumentMatchers.any())).thenReturn((Object)true);
        EntryEvent<String, DistributedApiConfigurationEntry> entry = this.mockEntry(false);
        this.entryListener.entryAdded(entry);
        this.assertWithDeployedApi(entry);
        this.assertStoringLogs();
    }

    @Test
    public void notDeployedApiEntryAddedNonLocalMember() {
        Mockito.when((Object)this.apiService.isDeployed((ApiKey)ArgumentMatchers.any())).thenReturn((Object)false);
        EntryEvent<String, DistributedApiConfigurationEntry> entry = this.mockEntry(false);
        this.entryListener.entryAdded(entry);
        this.assertWithNotDeployedApi(entry);
        this.assertStoringLogs();
    }

    @Test
    public void entryUpdateLocalMember() {
        EntryEvent<String, DistributedApiConfigurationEntry> entry = this.mockEntry(true);
        this.entryListener.entryUpdated(entry);
        this.verifyNoServiceInteractions();
        MatcherAssert.assertThat((Object)this.logger.getAllLoggingEvents(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)((LoggingEvent)this.logger.getAllLoggingEvents().get(0)), (Matcher)LogMatcher.logMatches((LoggingEvent)this.entryModifiedDebugLine()));
    }

    @Test
    public void deployApiEntryUpdatedNonLocalMember() {
        Mockito.when((Object)this.apiService.isDeployed((ApiKey)ArgumentMatchers.any())).thenReturn((Object)true);
        EntryEvent<String, DistributedApiConfigurationEntry> entry = this.mockEntry(false);
        this.entryListener.entryUpdated(entry);
        this.assertWithDeployedApi(entry);
        this.assertUpdatingLogs();
    }

    @Test
    public void notDeployedApiEntryUpdatedNonLocalMember() {
        Mockito.when((Object)this.apiService.isDeployed((ApiKey)ArgumentMatchers.any())).thenReturn((Object)false);
        EntryEvent<String, DistributedApiConfigurationEntry> entry = this.mockEntry(false);
        this.entryListener.entryUpdated(entry);
        this.assertWithNotDeployedApi(entry);
        this.assertUpdatingLogs();
    }

    @Test
    public void onEntryRemovedLocalMember() {
        EntryEvent<String, DistributedApiConfigurationEntry> entry = this.mockEntry(true);
        this.entryListener.entryRemoved(entry);
        ((EntryEvent)Mockito.verify(entry)).isLocalMember();
        ((EntryEvent)Mockito.verify(entry, (VerificationMode)Mockito.times((int)2))).getKey();
        Mockito.verifyNoInteractions((Object[])new Object[]{this.apiTrackingService});
        MatcherAssert.assertThat((Object)this.logger.getAllLoggingEvents(), (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat((Object)((LoggingEvent)this.logger.getAllLoggingEvents().get(0)), (Matcher)LogMatcher.logMatches((LoggingEvent)this.entryRemovedDebugLine()));
        MatcherAssert.assertThat((Object)((LoggingEvent)this.logger.getAllLoggingEvents().get(1)), (Matcher)LogMatcher.logMatches((LoggingEvent)this.firedRemovalDebugLine()));
    }

    @Test
    public void onEntryRemovedNonLocalMember() {
        EntryEvent<String, DistributedApiConfigurationEntry> entry = this.mockEntry(false);
        this.entryListener.entryRemoved(entry);
        ((EntryEvent)Mockito.verify(entry)).isLocalMember();
        ((EntryEvent)Mockito.verify(entry, (VerificationMode)Mockito.times((int)3))).getKey();
        ((ApiTrackingService)Mockito.verify((Object)this.apiTrackingService)).apiUntracked(PolicyTestValuesConstants.API_KEY);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.apiTrackingService});
        MatcherAssert.assertThat((Object)this.logger.getAllLoggingEvents(), (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat((Object)((LoggingEvent)this.logger.getAllLoggingEvents().get(0)), (Matcher)LogMatcher.logMatches((LoggingEvent)this.entryRemovedDebugLine()));
        MatcherAssert.assertThat((Object)((LoggingEvent)this.logger.getAllLoggingEvents().get(1)), (Matcher)LogMatcher.logMatches((LoggingEvent)this.removingEntryDebugLine()));
    }

    private EntryEvent<String, DistributedApiConfigurationEntry> mockEntry(boolean isLocalMember) {
        EntryEvent entry = (EntryEvent)Mockito.mock(EntryEvent.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)entry.getKey()).thenReturn((Object)PolicyTestValuesConstants.API_KEY.id().toString());
        Mockito.when((Object)entry.getValue()).thenReturn((Object)this.apiConfigurationEntry());
        Mockito.when((Object)entry.isLocalMember()).thenReturn((Object)isLocalMember);
        return entry;
    }

    private void verifyNoServiceInteractions() {
        Mockito.verifyNoInteractions((Object[])new Object[]{this.contractSnapshots});
        Mockito.verifyNoInteractions((Object[])new Object[]{this.apiTrackingService});
        Mockito.verifyNoInteractions((Object[])new Object[]{this.apiService});
        Mockito.verifyNoInteractions((Object[])new Object[]{this.policySetDeploymentService});
    }

    private void assertStoringLogs() {
        MatcherAssert.assertThat((Object)this.logger.getAllLoggingEvents(), (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat((Object)((LoggingEvent)this.logger.getAllLoggingEvents().get(0)), (Matcher)LogMatcher.logMatches((LoggingEvent)this.entryAddedDebugLine()));
        MatcherAssert.assertThat((Object)((LoggingEvent)this.logger.getAllLoggingEvents().get(1)), (Matcher)LogMatcher.logMatches((LoggingEvent)this.entryStoringDebugLine()));
    }

    private void assertUpdatingLogs() {
        MatcherAssert.assertThat((Object)this.logger.getAllLoggingEvents(), (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat((Object)((LoggingEvent)this.logger.getAllLoggingEvents().get(0)), (Matcher)LogMatcher.logMatches((LoggingEvent)this.entryModifiedDebugLine()));
        MatcherAssert.assertThat((Object)((LoggingEvent)this.logger.getAllLoggingEvents().get(1)), (Matcher)LogMatcher.logMatches((LoggingEvent)this.entryBackupDebugLine()));
    }

    private void assertWithDeployedApi(EntryEvent<String, DistributedApiConfigurationEntry> entry) {
        ApiKey apiKey = PolicyTestValuesConstants.API_KEY;
        PolicySet policySet = ((DistributedApiConfigurationEntry)entry.getValue()).getPolicySet();
        List slas = ((DistributedApiConfigurationEntry)entry.getValue()).getSlas();
        ((ApiService)Mockito.verify((Object)this.apiService)).isDeployed(apiKey);
        ((ContractSnapshots)Mockito.verify((Object)this.contractSnapshots)).slas((ApiKey)ArgumentMatchers.eq((Object)apiKey), (List)ArgumentMatchers.eq((Object)slas));
        ((PolicySetDeploymentService)Mockito.verify((Object)this.policySetDeploymentService)).policiesForApi((ApiKey)ArgumentMatchers.eq((Object)apiKey), (PolicySet)ArgumentMatchers.eq((Object)policySet));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.apiService});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.contractSnapshots});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.policySetDeploymentService});
        Mockito.verifyNoInteractions((Object[])new Object[]{this.apiTrackingService});
    }

    private void assertWithNotDeployedApi(EntryEvent<String, DistributedApiConfigurationEntry> entry) {
        ApiKey apiKey = PolicyTestValuesConstants.API_KEY;
        List policyDefinitions = ((DistributedApiConfigurationEntry)entry.getValue()).getPolicySet().getPolicyDefinitions();
        ((ApiService)Mockito.verify((Object)this.apiService)).isDeployed(apiKey);
        ((PolicySetDeploymentService)Mockito.verify((Object)this.policySetDeploymentService)).conciliatePolicies((ApiKey)ArgumentMatchers.eq((Object)apiKey), (List)ArgumentMatchers.eq((Object)policyDefinitions));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.apiService});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.policySetDeploymentService});
        Mockito.verifyNoInteractions((Object[])new Object[]{this.apiTrackingService});
        Mockito.verifyNoInteractions((Object[])new Object[]{this.contractSnapshots});
    }

    private DistributedApiConfigurationEntry apiConfigurationEntry() {
        return new DistributedApiConfigurationEntry(new PolicySet(Arrays.asList(this.policyDefinition), PolicySet.PolicySetOrigin.PLATFORM), new ArrayList()){
            private static final long serialVersionUID = -7490827916319887757L;

            public int hashCode() {
                return 1902;
            }
        };
    }

    private LoggingEvent removingEntryDebugLine() {
        return new LoggingEvent(Level.DEBUG, "Removing map entry [{}] as the requester is not us.", new Object[]{PolicyTestValuesConstants.API_KEY});
    }

    private LoggingEvent entryRemovedDebugLine() {
        return new LoggingEvent(Level.DEBUG, "Policies map entry removed [{}].", new Object[]{PolicyTestValuesConstants.API_KEY});
    }

    private LoggingEvent firedRemovalDebugLine() {
        return new LoggingEvent(Level.DEBUG, "Local member fired the removal of [{}].", new Object[]{PolicyTestValuesConstants.API_KEY});
    }

    private LoggingEvent entryAddedDebugLine() {
        return new LoggingEvent(Level.DEBUG, "Policies map entry added [{}] by {} [hashCode={}]", new Object[]{PolicyTestValuesConstants.API_KEY, null, 1902});
    }

    private LoggingEvent entryStoringDebugLine() {
        return new LoggingEvent(Level.DEBUG, "Storing map entry [{}] into map store as a backup", new Object[]{PolicyTestValuesConstants.API_KEY});
    }

    private LoggingEvent entryModifiedDebugLine() {
        return new LoggingEvent(Level.DEBUG, "Policies map entry updated [{}] by {} [hashCode={}]", new Object[]{PolicyTestValuesConstants.API_KEY, null, 1902});
    }

    private LoggingEvent entryBackupDebugLine() {
        return new LoggingEvent(Level.DEBUG, "Updating map entry [{}] into map store as a backup", new Object[]{PolicyTestValuesConstants.API_KEY});
    }
}

