/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.deployment.tracking;

import com.google.common.collect.Lists;
import com.mulesoft.anypoint.tests.PolicyTestValuesConstants;
import com.mulesoft.mule.runtime.gw.api.config.GateKeeperConfiguration;
import com.mulesoft.mule.runtime.gw.api.config.OnApiDeletedConfiguration;
import com.mulesoft.mule.runtime.gw.api.contract.Sla;
import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.mule.runtime.gw.api.service.ContractService;
import com.mulesoft.mule.runtime.gw.deployment.api.ApiService;
import com.mulesoft.mule.runtime.gw.deployment.contracts.ContractSnapshots;
import com.mulesoft.mule.runtime.gw.deployment.replication.ApiConfigurationCache;
import com.mulesoft.mule.runtime.gw.deployment.tracking.ApiTrackingService;
import com.mulesoft.mule.runtime.gw.deployment.tracking.DefaultApiTrackingService;
import com.mulesoft.mule.runtime.gw.model.Api;
import com.mulesoft.mule.runtime.gw.model.NoTrackingInfo;
import com.mulesoft.mule.runtime.gw.model.PolicySet;
import com.mulesoft.mule.runtime.gw.model.TrackingInfo;
import com.mulesoft.mule.runtime.gw.policies.service.PolicySetDeploymentService;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.mule.tck.junit4.AbstractMuleTestCase;

@RunWith(value=MockitoJUnitRunner.class)
public class DefaultApiTrackingServiceTestCase
extends AbstractMuleTestCase {
    @Mock
    private ApiService apiService;
    @Mock
    private PolicySetDeploymentService policySetDeploymentService;
    @Mock
    private ApiConfigurationCache apiConfigurationCache;
    @Mock
    private ContractSnapshots contractSnapshots;
    @Mock
    private ContractService contractService;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private Api api;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private Api anotherApi;
    @Mock
    private Api untrackedApi;
    @Mock
    private Api failedApi;
    private ApiTrackingService service;

    @Before
    public void setUp() {
        this.service = new DefaultApiTrackingService(this.apiService, this.policySetDeploymentService, this.apiConfigurationCache, this.contractSnapshots, this.contractService, new OnApiDeletedConfiguration(new GateKeeperConfiguration()));
        Mockito.when((Object)this.apiService.get(PolicyTestValuesConstants.API_KEY)).thenReturn(Optional.of(this.api));
        Mockito.when((Object)this.api.getKey()).thenReturn((Object)PolicyTestValuesConstants.API_KEY);
        Mockito.when((Object)this.api.getTrackingInfo().isTracked()).thenReturn((Object)true);
        Mockito.when((Object)this.anotherApi.getTrackingInfo().isTracked()).thenReturn((Object)true);
        Mockito.when((Object)this.untrackedApi.getTrackingInfo()).thenReturn((Object)NoTrackingInfo.untracked());
        Mockito.when((Object)this.failedApi.getTrackingInfo()).thenReturn((Object)NoTrackingInfo.trackingFailed());
    }

    @Test
    public void apiTracked() {
        TrackingInfo trackingInfo = (TrackingInfo)Mockito.mock(TrackingInfo.class);
        PolicySet policySet = (PolicySet)Mockito.mock(PolicySet.class);
        ArrayList slas = Lists.newArrayList((Object[])new Sla[]{(Sla)Mockito.mock(Sla.class)});
        this.service.apiTracked(PolicyTestValuesConstants.API_KEY, trackingInfo, policySet, (List)slas);
        ((Api)Mockito.verify((Object)this.api)).updateTrackingInfo(trackingInfo);
        ((ApiConfigurationCache)Mockito.verify((Object)this.apiConfigurationCache)).set(PolicyTestValuesConstants.API_KEY, policySet, (List)slas);
        ((PolicySetDeploymentService)Mockito.verify((Object)this.policySetDeploymentService)).policiesForApi(PolicyTestValuesConstants.API_KEY, policySet);
        ((ContractSnapshots)Mockito.verify((Object)this.contractSnapshots)).slas(PolicyTestValuesConstants.API_KEY, (List)slas);
    }

    @Test
    public void apiUntrackedAndBlocked() {
        try {
            System.setProperty("anypoint.platform.policies.on_api_deleted", "BLOCK_API");
            this.service.apiUntracked(PolicyTestValuesConstants.API_KEY);
            ((Api)Mockito.verify((Object)this.api)).updateTrackingInfo((TrackingInfo)NoTrackingInfo.untracked());
            ((ApiConfigurationCache)Mockito.verify((Object)this.apiConfigurationCache)).remove(PolicyTestValuesConstants.API_KEY);
            ((PolicySetDeploymentService)Mockito.verify((Object)this.policySetDeploymentService)).removeAll(PolicyTestValuesConstants.API_KEY);
        }
        finally {
            System.clearProperty("anypoint.platform.policies.on_api_deleted");
        }
    }

    @Test
    public void apiUntrackedAndKept() {
        PolicySet policySet = (PolicySet)Mockito.mock(PolicySet.class);
        Mockito.when((Object)this.apiConfigurationCache.getPolicies(PolicyTestValuesConstants.API_KEY)).thenReturn(Optional.of(policySet));
        this.service.apiUntracked(PolicyTestValuesConstants.API_KEY);
        ((Api)Mockito.verify((Object)this.api)).updateTrackingInfo((TrackingInfo)NoTrackingInfo.untracked());
        ((PolicySetDeploymentService)Mockito.verify((Object)this.policySetDeploymentService)).policiesForApi(PolicyTestValuesConstants.API_KEY, policySet);
    }

    @Test
    public void apiTrackingFailed() {
        PolicySet policySet = (PolicySet)Mockito.mock(PolicySet.class);
        Mockito.when((Object)this.apiConfigurationCache.getPolicies(PolicyTestValuesConstants.API_KEY)).thenReturn(Optional.of(policySet));
        Mockito.when((Object)this.api.getTrackingInfo()).thenReturn((Object)NoTrackingInfo.untracked());
        this.service.apiTrackingFailed(PolicyTestValuesConstants.API_KEY);
        ((Api)Mockito.verify((Object)this.api)).updateTrackingInfo((TrackingInfo)NoTrackingInfo.trackingFailed());
        ((PolicySetDeploymentService)Mockito.verify((Object)this.policySetDeploymentService)).policiesForApi(PolicyTestValuesConstants.API_KEY, policySet);
    }

    @Test
    public void apiTrackingFailedAfterItAlreadyFailed() {
        PolicySet policySet = (PolicySet)Mockito.mock(PolicySet.class);
        Mockito.when((Object)this.apiConfigurationCache.getPolicies(PolicyTestValuesConstants.API_KEY)).thenReturn(Optional.of(policySet));
        Mockito.when((Object)this.api.getTrackingInfo()).thenReturn((Object)NoTrackingInfo.trackingFailed());
        this.service.apiTrackingFailed(PolicyTestValuesConstants.API_KEY);
        ((Api)Mockito.verify((Object)this.api, (VerificationMode)Mockito.never())).updateTrackingInfo((TrackingInfo)NoTrackingInfo.trackingFailed());
        ((PolicySetDeploymentService)Mockito.verify((Object)this.policySetDeploymentService, (VerificationMode)Mockito.never())).policiesForApi(PolicyTestValuesConstants.API_KEY, policySet);
    }

    @Test
    public void getTrackedApis() {
        Mockito.when((Object)this.apiService.getApis()).thenReturn((Object)Lists.newArrayList((Object[])new Api[]{this.api, this.anotherApi, this.untrackedApi, this.failedApi}));
        List trackedApis = this.service.getTrackedApis();
        Assert.assertThat((Object)trackedApis, (Matcher)Matchers.contains((Object[])new Api[]{this.api, this.anotherApi}));
    }

    @Test
    public void getFailedApis() {
        Mockito.when((Object)this.apiService.getApis()).thenReturn((Object)Lists.newArrayList((Object[])new Api[]{this.api, this.anotherApi, this.untrackedApi, this.failedApi}));
        List failedApis = this.service.getFailedTrackingApis();
        Assert.assertThat((Object)failedApis, (Matcher)Matchers.contains((Object[])new Api[]{this.failedApi}));
    }

    @Test
    public void getTrackedApisRequiringContracts() {
        ApiKey anotherApiKey = (ApiKey)Mockito.mock(ApiKey.class);
        ApiKey untrackedApiKey = (ApiKey)Mockito.mock(ApiKey.class);
        ApiKey failedApiKey = (ApiKey)Mockito.mock(ApiKey.class);
        Mockito.when((Object)this.anotherApi.getKey()).thenReturn((Object)anotherApiKey);
        Mockito.when((Object)this.untrackedApi.getKey()).thenReturn((Object)untrackedApiKey);
        Mockito.when((Object)this.failedApi.getKey()).thenReturn((Object)failedApiKey);
        Mockito.when((Object)this.contractService.trackedApis()).thenReturn((Object)Lists.newArrayList((Object[])new ApiKey[]{PolicyTestValuesConstants.API_KEY, untrackedApiKey, failedApiKey}));
        Mockito.when((Object)this.apiService.getApis()).thenReturn((Object)Lists.newArrayList((Object[])new Api[]{this.api, this.anotherApi, this.untrackedApi, this.failedApi}));
        List requiringContracts = this.service.getTrackedApisRequiringContracts();
        Assert.assertThat((Object)requiringContracts, (Matcher)Matchers.contains((Object[])new Api[]{this.api}));
    }
}

