/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.deployment;

import com.mulesoft.anypoint.backoff.scheduler.configuration.SchedulingConfiguration;
import com.mulesoft.anypoint.tests.DescriptiveProbe;
import com.mulesoft.mule.runtime.gw.api.service.ContractService;
import com.mulesoft.mule.runtime.gw.api.time.period.Period;
import com.mulesoft.mule.runtime.gw.client.ApiPlatformClient;
import com.mulesoft.mule.runtime.gw.client.provider.ApiPlatformClientConnectionListener;
import com.mulesoft.mule.runtime.gw.deployment.ApiDeploymentCoreExtension;
import com.mulesoft.mule.runtime.gw.deployment.OfflineModeApiDeploymentListener;
import com.mulesoft.mule.runtime.gw.deployment.platform.interaction.PlatformInteractionLifecycle;
import com.mulesoft.mule.runtime.gw.deployment.service.DefaultApiService;
import com.mulesoft.mule.runtime.gw.deployment.tracking.RetriableApiTracker;
import com.mulesoft.mule.runtime.gw.metrics.GatewayMetricsAdapter;
import com.mulesoft.mule.runtime.gw.metrics.event.status.ApiRequestsTracker;
import com.mulesoft.mule.runtime.gw.notification.ApiDeploymentListener;
import com.mulesoft.mule.runtime.gw.policies.lifecyle.FlexibleGateKeeper;
import com.mulesoft.mule.runtime.gw.policies.lifecyle.HdpApisHealthCheckListener;
import com.mulesoft.mule.runtime.gw.policies.lifecyle.StrictGateKeeper;
import com.mulesoft.mule.runtime.gw.policies.service.PolicySetDeploymentService;
import com.mulesoft.mule.runtime.gw.reflection.Inspector;
import com.mulesoft.mule.runtime.gw.reflection.VariableOverride;
import com.mulesoft.mule.runtime.module.cluster.api.ClusterCoreExtension;
import com.mulesoft.mule.runtime.module.cluster.api.exception.ClusterQuorumException;
import com.mulesoft.mule.runtime.module.cluster.internal.HazelcastClusterCoreExtension;
import com.mulesoft.mule.runtime.module.cluster.internal.HazelcastClusterManager;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.locks.Lock;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lock.LockFactory;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.deployment.api.DeploymentListener;
import org.mule.runtime.module.deployment.api.DeploymentService;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.tck.junit4.rule.SystemPropertyTemporaryFolder;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;

@RunWith(value=Parameterized.class)
public class ApiDeploymentCoreExtensionTestCase
extends AbstractMuleTestCase {
    public static final String ENCRYPTION_SYSTEM_PROPERTY = "anypoint.platform.encryption_key";
    @Rule
    public SystemPropertyTemporaryFolder muleHome = new SystemPropertyTemporaryFolder("mule.home");
    @Rule
    public SystemProperty clientId = new SystemProperty("anypoint.platform.client_id", "clientId");
    @Rule
    public SystemProperty clientSecret = new SystemProperty("anypoint.platform.client_secret", "clientSecret");
    private HazelcastClusterManager clusterManager;
    private DeploymentService deploymentService;
    private ApiPlatformClient client;
    private LockFactory lockFactory;
    private ApiDeploymentCoreExtension coreExtension;

    public ApiDeploymentCoreExtensionTestCase(HazelcastClusterManager clusterManager) {
        this.clusterManager = clusterManager;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({Mockito.mock(HazelcastClusterManager.class, (Answer)Mockito.RETURNS_DEEP_STUBS)}, {null});
    }

    @Before
    public void setUp() {
        HazelcastClusterCoreExtension clusterCoreExtension = (HazelcastClusterCoreExtension)Mockito.mock(HazelcastClusterCoreExtension.class);
        ArtifactClassLoader artifactClassloader = (ArtifactClassLoader)Mockito.mock(ArtifactClassLoader.class);
        this.deploymentService = (DeploymentService)Mockito.mock(DeploymentService.class);
        this.client = (ApiPlatformClient)Mockito.mock(ApiPlatformClient.class);
        this.lockFactory = (LockFactory)Mockito.mock(LockFactory.class);
        Mockito.when((Object)clusterCoreExtension.getClusterManager()).thenReturn((Object)this.clusterManager);
        Mockito.when((Object)artifactClassloader.getClassLoader()).thenReturn((Object)Thread.currentThread().getContextClassLoader());
        Mockito.when((Object)this.lockFactory.createLock(ArgumentMatchers.anyString())).thenReturn((Object)((Lock)Mockito.mock(Lock.class)));
        this.coreExtension = new ApiDeploymentCoreExtension();
        this.coreExtension.setClusterCoreExtension((ClusterCoreExtension)clusterCoreExtension);
        this.coreExtension.setContainerClassLoader(artifactClassloader);
        this.coreExtension.setLockFactory(this.lockFactory);
        this.injectDeploymentService(this.deploymentService);
        this.overrideExtensionLoaded();
        this.overrideContractService();
        this.overridePlatformClient();
    }

    @After
    public void tearDown() {
        System.clearProperty("anypoint.platform.gatekeeper");
        System.clearProperty("anypoint.platform.metrics_enabled");
    }

    @Test
    public void metricsDisabled() {
        System.setProperty("anypoint.platform.metrics_enabled", "false");
        this.coreExtension.initialiseCoreExtension();
        this.coreExtension.finishCoreExtensionInitialization();
        MatcherAssert.assertThat(this.getDeploymentListeners(), (Matcher)Matchers.contains((Matcher[])new Matcher[]{Matchers.instanceOf(HdpApisHealthCheckListener.class), Matchers.instanceOf(PolicySetDeploymentService.class), Matchers.instanceOf(OfflineModeApiDeploymentListener.class)}));
        ((DeploymentService)Mockito.verify((Object)this.deploymentService)).addDeploymentListener((DeploymentListener)ArgumentMatchers.isA(DefaultApiService.class));
    }

    @Test
    public void gateKeeperDisabled() {
        System.setProperty("anypoint.platform.gatekeeper", "disabled");
        this.coreExtension.initialiseCoreExtension();
        this.coreExtension.finishCoreExtensionInitialization();
        MatcherAssert.assertThat(this.getDeploymentListeners(), (Matcher)Matchers.contains((Matcher[])new Matcher[]{Matchers.instanceOf(HdpApisHealthCheckListener.class), Matchers.instanceOf(PolicySetDeploymentService.class), Matchers.instanceOf(OfflineModeApiDeploymentListener.class), Matchers.instanceOf(GatewayMetricsAdapter.class), Matchers.instanceOf(ApiRequestsTracker.class)}));
        ((DeploymentService)Mockito.verify((Object)this.deploymentService)).addDeploymentListener((DeploymentListener)ArgumentMatchers.isA(DefaultApiService.class));
    }

    @Test
    public void strictGateKeeperEnabled() {
        System.setProperty("anypoint.platform.gatekeeper", "strict");
        this.coreExtension.initialiseCoreExtension();
        this.coreExtension.finishCoreExtensionInitialization();
        MatcherAssert.assertThat(this.getDeploymentListeners(), (Matcher)Matchers.contains((Matcher[])new Matcher[]{Matchers.instanceOf(HdpApisHealthCheckListener.class), Matchers.instanceOf(PolicySetDeploymentService.class), Matchers.instanceOf(OfflineModeApiDeploymentListener.class), Matchers.instanceOf(GatewayMetricsAdapter.class), Matchers.instanceOf(ApiRequestsTracker.class)}));
        this.coreExtension.startCoreExtension();
        this.coreExtension.initialiseRestClient();
        MatcherAssert.assertThat(this.getDeploymentListeners(), (Matcher)Matchers.hasItem((Matcher)Matchers.instanceOf(StrictGateKeeper.class)));
        ((DeploymentService)Mockito.verify((Object)this.deploymentService)).addDeploymentListener((DeploymentListener)ArgumentMatchers.isA(DefaultApiService.class));
    }

    @Test
    public void flexibleGateKeeperEnabled() {
        System.setProperty("anypoint.platform.gatekeeper", "flexible");
        this.coreExtension.initialiseCoreExtension();
        this.coreExtension.finishCoreExtensionInitialization();
        MatcherAssert.assertThat(this.getDeploymentListeners(), (Matcher)Matchers.contains((Matcher[])new Matcher[]{Matchers.instanceOf(HdpApisHealthCheckListener.class), Matchers.instanceOf(PolicySetDeploymentService.class), Matchers.instanceOf(OfflineModeApiDeploymentListener.class), Matchers.instanceOf(GatewayMetricsAdapter.class), Matchers.instanceOf(ApiRequestsTracker.class)}));
        this.coreExtension.startCoreExtension();
        this.coreExtension.initialiseRestClient();
        MatcherAssert.assertThat(this.getDeploymentListeners(), (Matcher)Matchers.hasItem((Matcher)Matchers.instanceOf(FlexibleGateKeeper.class)));
        ((DeploymentService)Mockito.verify((Object)this.deploymentService)).addDeploymentListener((DeploymentListener)ArgumentMatchers.isA(DefaultApiService.class));
    }

    @Test
    public void flexibleGateKeeperEnabledByDefault() {
        this.coreExtension.initialiseCoreExtension();
        this.coreExtension.finishCoreExtensionInitialization();
        MatcherAssert.assertThat(this.getDeploymentListeners(), (Matcher)Matchers.contains((Matcher[])new Matcher[]{Matchers.instanceOf(HdpApisHealthCheckListener.class), Matchers.instanceOf(PolicySetDeploymentService.class), Matchers.instanceOf(OfflineModeApiDeploymentListener.class), Matchers.instanceOf(GatewayMetricsAdapter.class), Matchers.instanceOf(ApiRequestsTracker.class)}));
        ((DeploymentService)Mockito.verify((Object)this.deploymentService)).addDeploymentListener((DeploymentListener)ArgumentMatchers.isA(DefaultApiService.class));
        this.coreExtension.startCoreExtension();
        MatcherAssert.assertThat(this.getDeploymentListeners(), (Matcher)Matchers.hasItem((Matcher)Matchers.instanceOf(FlexibleGateKeeper.class)));
    }

    @Test
    public void onFirstAppDeployed() {
        this.coreExtension.initialiseCoreExtension();
        this.coreExtension.finishLazyInitialization();
        MatcherAssert.assertThat(this.getDeploymentListeners(), (Matcher)Matchers.contains((Matcher[])new Matcher[]{Matchers.instanceOf(HdpApisHealthCheckListener.class), Matchers.instanceOf(PolicySetDeploymentService.class), Matchers.instanceOf(GatewayMetricsAdapter.class), Matchers.instanceOf(ApiRequestsTracker.class), Matchers.instanceOf(FlexibleGateKeeper.class), Matchers.instanceOf(RetriableApiTracker.class)}));
        ((DeploymentService)Mockito.verify((Object)this.deploymentService)).addDeploymentListener((DeploymentListener)ArgumentMatchers.isA(DefaultApiService.class));
        List<ApiPlatformClientConnectionListener> connectionListeners = this.getConnectionListeners();
        MatcherAssert.assertThat(connectionListeners, (Matcher)Matchers.hasSize((int)5));
        MatcherAssert.assertThat((Object)connectionListeners.get(0), (Matcher)Matchers.instanceOf(PlatformInteractionLifecycle.class));
        MatcherAssert.assertThat((Object)connectionListeners.get(1), (Matcher)Matchers.instanceOf(PlatformInteractionLifecycle.class));
        MatcherAssert.assertThat((Object)connectionListeners.get(2), (Matcher)Matchers.instanceOf(PlatformInteractionLifecycle.class));
    }

    @Test
    public void onFirstAppDeployedAndClientInitFailure() {
        ((ApiPlatformClient)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).when((Object)this.client)).connect();
        this.coreExtension.initialiseCoreExtension();
        this.coreExtension.finishLazyInitialization();
        MatcherAssert.assertThat(this.getDeploymentListeners(), (Matcher)Matchers.contains((Matcher[])new Matcher[]{Matchers.instanceOf(HdpApisHealthCheckListener.class), Matchers.instanceOf(PolicySetDeploymentService.class), Matchers.instanceOf(OfflineModeApiDeploymentListener.class), Matchers.instanceOf(GatewayMetricsAdapter.class), Matchers.instanceOf(ApiRequestsTracker.class), Matchers.instanceOf(FlexibleGateKeeper.class)}));
        ((DeploymentService)Mockito.verify((Object)this.deploymentService)).addDeploymentListener((DeploymentListener)ArgumentMatchers.isA(DefaultApiService.class));
        List<ApiPlatformClientConnectionListener> connectionListeners = this.getConnectionListeners();
        MatcherAssert.assertThat(connectionListeners, (Matcher)Matchers.hasSize((int)5));
        MatcherAssert.assertThat((Object)connectionListeners.get(0), (Matcher)Matchers.instanceOf(PlatformInteractionLifecycle.class));
        MatcherAssert.assertThat((Object)connectionListeners.get(1), (Matcher)Matchers.instanceOf(PlatformInteractionLifecycle.class));
        MatcherAssert.assertThat((Object)connectionListeners.get(2), (Matcher)Matchers.instanceOf(PlatformInteractionLifecycle.class));
    }

    @Test
    public void policySetDeploymentServiceRetrierWithNoDelay() {
        this.coreExtension.initialiseCoreExtension();
        this.coreExtension.finishCoreExtensionInitialization();
        SchedulingConfiguration retrierSchedulingConfiguration = this.policySetDeploymentServiceRetrierConfiguration();
        MatcherAssert.assertThat((Object)retrierSchedulingConfiguration.delay(), (Matcher)Matchers.is((Object)Period.millis((long)0L)));
        MatcherAssert.assertThat((Object)retrierSchedulingConfiguration.frequency(), (Matcher)Matchers.is((Object)Period.millis((long)0L)));
    }

    @Test
    public void policySetDeploymentServiceRetrierThreadName() {
        this.coreExtension.initialiseCoreExtension();
        this.coreExtension.finishCoreExtensionInitialization();
        MatcherAssert.assertThat((Object)this.retrierThreadName(), (Matcher)Matchers.is((Object)"agw-policy-set-deployment"));
    }

    @Test
    public void removeSecretsWhenStoppingRuntime() throws MuleException {
        System.setProperty(ENCRYPTION_SYSTEM_PROPERTY, "GatewayTeamKey00");
        System.setProperty("anypoint.platform.client_secret", "SuperSecretClientSecret");
        this.coreExtension.stop();
        MatcherAssert.assertThat((Object)System.getProperty(ENCRYPTION_SYSTEM_PROPERTY, null), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)System.getProperty("anypoint.platform.client_secret", null), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void clusterReadyAfterRestClientConnected() {
        Assume.assumeThat((Object)this.clusterManager, (Matcher)Matchers.notNullValue());
        Mockito.when((Object)this.lockFactory.createLock(ArgumentMatchers.anyString())).thenThrow(ClusterQuorumException.class).thenReturn((Object)((Lock)Mockito.mock(Lock.class)));
        this.coreExtension.initialiseCoreExtension();
        this.coreExtension.finishLazyInitialization();
        new PollingProber(2000L, 100L).check((Probe)new DescriptiveProbe(() -> MatcherAssert.assertThat(this.getDeploymentListeners(), (Matcher)Matchers.hasItem((Matcher)Matchers.instanceOf(RetriableApiTracker.class)))));
    }

    private String retrierThreadName() {
        return (String)new Inspector((Object)this.coreExtension).read("policySetDeploymentService.runnableRetrier.threadName");
    }

    private SchedulingConfiguration policySetDeploymentServiceRetrierConfiguration() {
        return (SchedulingConfiguration)new Inspector((Object)this.coreExtension).read("policySetDeploymentService.runnableRetrier.initialSchedulingConfiguration");
    }

    private List<ApiDeploymentListener> getDeploymentListeners() {
        return (List)new Inspector((Object)this.coreExtension).read("apiService.apiNotificationManager.apiDeploymentListeners");
    }

    private List<ApiPlatformClientConnectionListener> getConnectionListeners() {
        return (List)new Inspector((Object)this.coreExtension).read("clientProvider.connectionListeners");
    }

    private void injectDeploymentService(DeploymentService deploymentService) {
        VariableOverride.overrideVariable((String)"deploymentService").in((Object)this.coreExtension).with((Object)deploymentService);
    }

    private void overridePlatformClient() {
        VariableOverride.overrideVariable((String)"clientProvider.client").in((Object)this.coreExtension).with((Object)this.client);
    }

    private void overrideExtensionLoaded() {
        VariableOverride.overrideVariable((String)"extensionLoaded").in((Object)this.coreExtension).with((Object)true);
    }

    private void overrideContractService() {
        VariableOverride.overrideVariable((String)"contractService").in((Object)this.coreExtension).with(Mockito.mock(ContractService.class));
    }
}

