/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.deployment.backoff;

import com.mulesoft.anypoint.backoff.configuration.BackoffConfiguration;
import com.mulesoft.anypoint.backoff.configuration.BackoffConfigurationSupplier;
import com.mulesoft.anypoint.backoff.function.dispersion.RangeDispersant;
import com.mulesoft.anypoint.backoff.scheduler.configuration.SchedulingConfiguration;
import com.mulesoft.anypoint.backoff.scheduler.factory.BackoffSchedulerFactory;
import com.mulesoft.anypoint.backoff.scheduler.runnable.BackoffRunnable;
import com.mulesoft.anypoint.test.backoff.BackoffTestCase;
import com.mulesoft.anypoint.test.backoff.engine.BackoffSimulation;
import com.mulesoft.anypoint.test.backoff.scheduler.factory.FixedExecutorBackoffSchedulerFactory;
import com.mulesoft.anypoint.tests.scheduler.ObservableScheduledExecutorService;
import com.mulesoft.anypoint.tests.scheduler.observer.ScheduledExecutorObserver;
import com.mulesoft.anypoint.tests.scheduler.observer.ScheduledTask;
import com.mulesoft.mule.runtime.gw.api.config.GatewayConfiguration;
import com.mulesoft.mule.runtime.gw.client.session.factory.ApiPlatformSessionFactory;
import com.mulesoft.mule.runtime.gw.deployment.backoff.mocks.SimulatedSessionStatusFactory;
import com.mulesoft.mule.runtime.gw.deployment.platform.interaction.apis.GatewayApisPoller;
import com.mulesoft.mule.runtime.gw.deployment.platform.interaction.clients.GatewayClientsPoller;
import com.mulesoft.mule.runtime.gw.deployment.platform.interaction.clients.PlatformClientsRetriever;
import com.mulesoft.mule.runtime.gw.deployment.platform.interaction.keepalive.GatewayKeepAlivePoller;
import com.mulesoft.mule.runtime.gw.deployment.tracking.ApiTrackingService;
import com.mulesoft.mule.runtime.gw.model.Api;
import com.mulesoft.mule.runtime.gw.model.gatekeeper.status.GatekeeperStatus;
import com.mulesoft.mule.runtime.gw.policies.service.PolicyDeploymentTracker;
import com.mulesoft.mule.runtime.gw.reflection.VariableOverride;
import java.util.Arrays;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.IntStream;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

public class GatewayPollersBackoffTestCase
extends BackoffTestCase {
    private Api api;
    private ApiTrackingService apiTrackingService;
    private PolicyDeploymentTracker policyDeploymentTracker;

    @Before
    public void setUp() {
        super.setUp();
        this.apiTrackingService = (ApiTrackingService)Mockito.mock(ApiTrackingService.class);
        this.policyDeploymentTracker = (PolicyDeploymentTracker)Mockito.mock(PolicyDeploymentTracker.class);
        this.api = (Api)Mockito.mock(Api.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        System.clearProperty("anypoint.platform.backoff");
    }

    @Test
    public void noInteractionKeepAliveRemainsStable() {
        this.noInteractionRemainsStable(this.keepAliveConfiguration(), this::keepAliveRunnable);
    }

    @Test
    public void noInteractionApisRemainsStable() {
        this.noInteractionRemainsStable(this.apisConfiguration(), this::apisRunnable);
    }

    @Test
    public void noInteractionClientsRemainsStable() {
        this.noInteractionRemainsStable(this.clientsConfiguration(), this::clientsRunnable);
    }

    private void noInteractionRemainsStable(SchedulingConfiguration schedulingConfiguration, Function<SimulatedSessionStatusFactory, BackoffRunnable> backoffRunnableFactory) {
        int simulationIterations = 100;
        BackoffSimulation simulation = this.backoffSimulation(schedulingConfiguration).simulate(simulationIterations);
        SimulatedSessionStatusFactory platformFactory = this.simulatedPlatformSession(simulation);
        BackoffRunnable backoffRunnable = backoffRunnableFactory.apply(platformFactory);
        this.assertExecutionMatchesSimulation(backoffRunnable, simulation, platformFactory, simulationIterations);
    }

    @Test
    public void keepAliveBackoffBackon() {
        this.runBackoffBackonSimulation(this.keepAliveConfiguration(), this::noDispersionKeepAliveRunnable);
    }

    @Test
    public void apisBackoffBackon() {
        this.runBackoffBackonSimulation(this.apisConfiguration(), this::noDispersionApisRunnable);
    }

    @Test
    public void clientsBackoffBackon() {
        this.runBackoffBackonSimulation(this.clientsConfiguration(), this::noDispersionClientsRunnable);
    }

    private void runBackoffBackonSimulation(SchedulingConfiguration schedulingConfiguration, Function<SimulatedSessionStatusFactory, BackoffRunnable> backoffRunnableFactory) {
        BackoffSimulation simulation = this.backoffSimulation(schedulingConfiguration).off(0, 7, 503).simulate(11);
        this.assertExecutionMatchesSimulation(backoffRunnableFactory, simulation, 11);
    }

    @Test
    public void keepAliveDoNotBackoffOnAllErrors() {
        this.doNotBackoffOnAllErrors(this.keepAliveConfiguration(), this::noDispersionKeepAliveRunnable);
    }

    @Test
    public void apisDoNotBackoffOnAllErrors() {
        this.doNotBackoffOnAllErrors(this.apisConfiguration(), this::noDispersionApisRunnable);
    }

    @Test
    public void clientsDoNotBackoffOnAllErrors() {
        this.doNotBackoffOnAllErrors(this.clientsConfiguration(), this::noDispersionClientsRunnable);
    }

    private void doNotBackoffOnAllErrors(SchedulingConfiguration schedulingConfiguration, Function<SimulatedSessionStatusFactory, BackoffRunnable> backoffRunnableFactory) {
        BackoffSimulation simulation = this.backoffSimulation(schedulingConfiguration).off(0, 77, 418).disabled().simulate(100);
        this.assertExecutionMatchesSimulation(backoffRunnableFactory, simulation, 100);
    }

    @Test
    public void keepAliveHalfUpFullDown() {
        this.halfUpFullDown(this.keepAliveConfiguration(), this::noDispersionKeepAliveRunnable);
    }

    @Test
    public void apisHalfUpFullDown() {
        this.halfUpFullDown(this.apisConfiguration(), this::noDispersionApisRunnable);
    }

    @Test
    public void clientsHalfUpFullDown() {
        this.halfUpFullDown(this.clientsConfiguration(), this::noDispersionClientsRunnable);
    }

    private void halfUpFullDown(SchedulingConfiguration schedulingConfiguration, Function<SimulatedSessionStatusFactory, BackoffRunnable> backoffRunnableFactory) {
        BackoffSimulation simulation = this.backoffSimulation(schedulingConfiguration).off(0, 3, 503).simulate(20);
        this.assertExecutionMatchesSimulation(backoffRunnableFactory, simulation, 20);
    }

    @Test
    public void keepAliveOscillation() {
        this.oscillation(this.keepAliveConfiguration(), this::noDispersionKeepAliveRunnable);
    }

    @Test
    public void apisOscillation() {
        this.oscillation(this.apisConfiguration(), this::noDispersionApisRunnable);
    }

    @Test
    public void clientsOscillation() {
        this.oscillation(this.clientsConfiguration(), this::noDispersionClientsRunnable);
    }

    private void oscillation(SchedulingConfiguration schedulingConfiguration, Function<SimulatedSessionStatusFactory, BackoffRunnable> backoffRunnableFactory) {
        BackoffSimulation simulation = this.backoffSimulation(schedulingConfiguration).off(0, 2, 503).off(4, 6, 503).off(8, 12, 503).off(14, 15, 503).off(16, 37, 503).off(38, 41, 503).simulate(60);
        this.assertExecutionMatchesSimulation(backoffRunnableFactory, simulation, 60);
    }

    @Test
    public void backoffDisabled() {
        System.setProperty("anypoint.platform.backoff", "false");
        BackoffSimulation simulation = this.backoffSimulation(this.keepAliveConfiguration()).off(0, 50, 503).disabled().simulate(50);
        this.assertExecutionMatchesSimulation(this::keepAliveRunnable, simulation, 50);
    }

    private BackoffRunnable noDispersionApisRunnable(SimulatedSessionStatusFactory platformFactory) {
        return this.withNoDispersion(this.apisPollersManager(platformFactory).schedule());
    }

    private BackoffRunnable noDispersionClientsRunnable(SimulatedSessionStatusFactory platformFactory) {
        return this.withNoDispersion(this.clientsPollersManager(platformFactory).schedule());
    }

    private BackoffRunnable noDispersionKeepAliveRunnable(SimulatedSessionStatusFactory platformFactory) {
        return this.withNoDispersion(this.keepAlivePollersManager(platformFactory).schedule());
    }

    private void trackAnApi() {
        Mockito.when((Object)this.apiTrackingService.getTrackedApis()).thenReturn(Arrays.asList(this.api));
        Mockito.when((Object)this.apiTrackingService.getTrackedApisRequiringContracts()).thenReturn(Arrays.asList(this.api));
        Mockito.when((Object)this.api.getImplementation().getFlow().getMuleContext().isStarted()).thenReturn((Object)true);
        Mockito.when((Object)this.api.getImplementation().gatekeeperStatus().isBlocked()).thenReturn((Object)false);
        Mockito.when((Object)this.api.getImplementation().gatekeeperStatus().status()).thenReturn((Object)GatekeeperStatus.READY);
    }

    private BackoffRunnable keepAliveRunnable(SimulatedSessionStatusFactory platformFactory) {
        return this.keepAlivePollersManager(platformFactory).schedule();
    }

    private BackoffRunnable apisRunnable(SimulatedSessionStatusFactory platformFactory) {
        return this.apisPollersManager(platformFactory).schedule();
    }

    private BackoffRunnable clientsRunnable(SimulatedSessionStatusFactory platformFactory) {
        return this.clientsPollersManager(platformFactory).schedule();
    }

    private void assertExecutionMatchesSimulation(Function<SimulatedSessionStatusFactory, BackoffRunnable> backoffRunnableFactory, BackoffSimulation simulation, int simulationIterations) {
        this.trackAnApi();
        SimulatedSessionStatusFactory platformFactory = this.simulatedPlatformSession(simulation);
        BackoffRunnable backoffRunnable = backoffRunnableFactory.apply(platformFactory);
        this.assertExecutionMatchesSimulation(backoffRunnable, simulation, platformFactory, simulationIterations);
    }

    private void assertExecutionMatchesSimulation(BackoffRunnable backoffRunnable, BackoffSimulation simulation, SimulatedSessionStatusFactory platformFactory, int simulationIterations) {
        IntStream.range(0, simulationIterations).forEach(i -> {
            platformFactory.iteration(i);
            this.scheduledRunnable(i).run();
            MatcherAssert.assertThat((String)this.iteration(i), (Object)((ScheduledTask)this.executorLogger.scheduledTasks().get(i)), (Matcher)Matchers.is((Object)new ScheduledTask((Runnable)backoffRunnable, simulation.delay(i), 0L, TimeUnit.MILLISECONDS)));
        });
    }

    private GatewayApisPoller apisPollersManager(ApiPlatformSessionFactory platformSessionFactory) {
        return new GatewayApisPoller(new GatewayConfiguration(), this.apiTrackingService, platformSessionFactory, this.backoffSchedulerFactory(), new BackoffConfigurationSupplier());
    }

    private GatewayClientsPoller clientsPollersManager(ApiPlatformSessionFactory platformSessionFactory) {
        return new GatewayClientsPoller(new GatewayConfiguration(), this.apiTrackingService, platformSessionFactory, this.backoffSchedulerFactory(), new BackoffConfigurationSupplier(), new PlatformClientsRetriever(platformSessionFactory, this.apiTrackingService));
    }

    private GatewayKeepAlivePoller keepAlivePollersManager(ApiPlatformSessionFactory platformSessionFactory) {
        return new GatewayKeepAlivePoller(new GatewayConfiguration(), this.apiTrackingService, this.policyDeploymentTracker, platformSessionFactory, this.backoffSchedulerFactory(), new BackoffConfigurationSupplier());
    }

    private BackoffSimulation backoffSimulation(SchedulingConfiguration schedulingConfiguration) {
        return new BackoffSimulation(schedulingConfiguration.delay(), schedulingConfiguration.frequency(), this.withNoDispersion(this.backoffConfiguration()));
    }

    private SimulatedSessionStatusFactory simulatedPlatformSession(BackoffSimulation simulation) {
        return new SimulatedSessionStatusFactory(simulation);
    }

    private BackoffSchedulerFactory backoffSchedulerFactory() {
        return new FixedExecutorBackoffSchedulerFactory((ScheduledExecutorService)new ObservableScheduledExecutorService(new ScheduledExecutorObserver[]{this.executorLogger}));
    }

    private SchedulingConfiguration keepAliveConfiguration() {
        return new GatewayKeepAlivePoller(new GatewayConfiguration(), null, null, null, null, null).configuration();
    }

    private SchedulingConfiguration apisConfiguration() {
        return new GatewayApisPoller(new GatewayConfiguration(), null, null, null, null).configuration();
    }

    private SchedulingConfiguration clientsConfiguration() {
        return new GatewayClientsPoller(new GatewayConfiguration(), null, null, null, null, null).configuration();
    }

    protected BackoffConfiguration withNoDispersion(BackoffConfiguration configuration) {
        MatcherAssert.assertThat((String)"Backoff dispersion function ill configured", (Object)((RangeDispersant)this.read(configuration, "backoffFunction.function.dispersant")), (Matcher)Matchers.is((Object)this.expectedBackoffDispersion()));
        MatcherAssert.assertThat((String)"Backon dispersion function ill configured", (Object)((RangeDispersant)this.read(configuration, "backonFunction.function.dispersant")), (Matcher)Matchers.is((Object)this.expectedBackonDispersion()));
        return new BackoffConfiguration.Builder(true).backoff(2.5, 14.0, 5, Function.identity()).backon(2.5, 14.0, 3, Function.identity()).build();
    }

    private BackoffRunnable withNoDispersion(BackoffRunnable backoffRunnable) {
        BackoffConfiguration configuration = (BackoffConfiguration)this.read(backoffRunnable, "currentState.configuration");
        VariableOverride.overrideVariable((String)"currentState.configuration").in((Object)backoffRunnable).with((Object)this.withNoDispersion(configuration));
        return backoffRunnable;
    }

    private BackoffConfiguration backoffConfiguration() {
        return new BackoffConfiguration.Builder(true).build();
    }
}

