/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.deployment.contracts;

import com.github.valfirst.slf4jtest.LoggingEvent;
import com.github.valfirst.slf4jtest.TestLogger;
import com.github.valfirst.slf4jtest.TestLoggerFactory;
import com.mulesoft.anypoint.tests.logger.LogMatcher;
import com.mulesoft.mule.runtime.gw.deployment.contracts.ContractSnapshot;
import com.mulesoft.mule.runtime.gw.deployment.contracts.ContractSnapshotsTestCase;
import com.mulesoft.mule.runtime.gw.model.contracts.ClientFactory;
import com.mulesoft.mule.runtime.gw.model.contracts.DefaultClientFactory;
import java.util.Arrays;
import java.util.Collections;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.mule.tck.junit4.rule.LogCleanup;
import uk.org.lidalia.slf4jext.Level;

public class ContractSnapshotLoggerTestCase
extends ContractSnapshotsTestCase {
    @Rule
    public TestRule chain = RuleChain.outerRule((TestRule)new LogCleanup());
    private TestLogger logger;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.logger = TestLoggerFactory.getTestLogger(ContractSnapshot.class);
    }

    @Test
    public void addSlasToNewSnapshot() {
        ContractSnapshot snapshot = new ContractSnapshot((ClientFactory)new DefaultClientFactory());
        snapshot.platformSlas(Arrays.asList(this.sla(1), this.slaWithMultipleLimits(1902)));
        MatcherAssert.assertThat((Object)this.logger.getAllLoggingEvents().size(), (Matcher)Matchers.is((Object)4));
        MatcherAssert.assertThat((Object)((LoggingEvent)this.logger.getAllLoggingEvents().get(0)), (Matcher)LogMatcher.logMatches((LoggingEvent)new LoggingEvent(Level.DEBUG, "Received new SLAs: {}", new Object[]{Arrays.asList(this.sla(1), this.slaWithMultipleLimits(1902))})));
        MatcherAssert.assertThat((Object)((LoggingEvent)this.logger.getAllLoggingEvents().get(1)), (Matcher)LogMatcher.logMatches((LoggingEvent)new LoggingEvent(Level.DEBUG, "The following SLAs were modified: {}", new Object[]{Collections.emptyList()})));
        MatcherAssert.assertThat((Object)((LoggingEvent)this.logger.getAllLoggingEvents().get(2)), (Matcher)LogMatcher.logMatches((LoggingEvent)new LoggingEvent(Level.DEBUG, "The following SLAs were not modified: {}", new Object[]{Collections.emptyList()})));
        MatcherAssert.assertThat((Object)((LoggingEvent)this.logger.getAllLoggingEvents().get(3)), (Matcher)LogMatcher.logMatches((LoggingEvent)new LoggingEvent(Level.DEBUG, "The following SLAs were not returned by the platform: {}", new Object[]{Collections.emptyList()})));
    }

    @Test
    public void modifySingleSlaIsLogged() {
        ContractSnapshot snapshot = new ContractSnapshot(Arrays.asList(this.contractSingleLimit(1)), (ClientFactory)new DefaultClientFactory());
        snapshot.platformSlas(Arrays.asList(this.slaWithMultipleLimits(1)));
        MatcherAssert.assertThat((Object)this.logger.getAllLoggingEvents().size(), (Matcher)Matchers.is((Object)4));
        MatcherAssert.assertThat((Object)((LoggingEvent)this.logger.getAllLoggingEvents().get(0)), (Matcher)LogMatcher.logMatches((LoggingEvent)new LoggingEvent(Level.DEBUG, "Received new SLAs: {}", new Object[]{Collections.emptyList()})));
        MatcherAssert.assertThat((Object)((LoggingEvent)this.logger.getAllLoggingEvents().get(1)), (Matcher)LogMatcher.logMatches((LoggingEvent)new LoggingEvent(Level.DEBUG, "The following SLAs were modified: {}", new Object[]{Arrays.asList(this.slaWithMultipleLimits(1))})));
        MatcherAssert.assertThat((Object)((LoggingEvent)this.logger.getAllLoggingEvents().get(2)), (Matcher)LogMatcher.logMatches((LoggingEvent)new LoggingEvent(Level.DEBUG, "The following SLAs were not modified: {}", new Object[]{Collections.emptyList()})));
        MatcherAssert.assertThat((Object)((LoggingEvent)this.logger.getAllLoggingEvents().get(3)), (Matcher)LogMatcher.logMatches((LoggingEvent)new LoggingEvent(Level.DEBUG, "The following SLAs were not returned by the platform: {}", new Object[]{Collections.emptyList()})));
    }

    @Test
    public void addAndModifySlasIsLogged() {
        ContractSnapshot snapshot = new ContractSnapshot(Arrays.asList(this.contractSingleLimit(1)), (ClientFactory)new DefaultClientFactory());
        snapshot.platformSlas(Arrays.asList(this.slaWithMultipleLimits(1), this.sla(1902)));
        MatcherAssert.assertThat((Object)this.logger.getAllLoggingEvents().size(), (Matcher)Matchers.is((Object)4));
        MatcherAssert.assertThat((Object)((LoggingEvent)this.logger.getAllLoggingEvents().get(0)), (Matcher)LogMatcher.logMatches((LoggingEvent)new LoggingEvent(Level.DEBUG, "Received new SLAs: {}", new Object[]{Arrays.asList(this.sla(1902))})));
        MatcherAssert.assertThat((Object)((LoggingEvent)this.logger.getAllLoggingEvents().get(1)), (Matcher)LogMatcher.logMatches((LoggingEvent)new LoggingEvent(Level.DEBUG, "The following SLAs were modified: {}", new Object[]{Arrays.asList(this.slaWithMultipleLimits(1))})));
        MatcherAssert.assertThat((Object)((LoggingEvent)this.logger.getAllLoggingEvents().get(2)), (Matcher)LogMatcher.logMatches((LoggingEvent)new LoggingEvent(Level.DEBUG, "The following SLAs were not modified: {}", new Object[]{Collections.emptyList()})));
        MatcherAssert.assertThat((Object)((LoggingEvent)this.logger.getAllLoggingEvents().get(3)), (Matcher)LogMatcher.logMatches((LoggingEvent)new LoggingEvent(Level.DEBUG, "The following SLAs were not returned by the platform: {}", new Object[]{Collections.emptyList()})));
    }

    @Test
    public void slaNotModifiedIsLogged() {
        ContractSnapshot snapshot = new ContractSnapshot(Arrays.asList(this.contractSingleLimit(1)), (ClientFactory)new DefaultClientFactory());
        snapshot.platformSlas(Arrays.asList(this.sla(1), this.sla(1902)));
        MatcherAssert.assertThat((Object)this.logger.getAllLoggingEvents().size(), (Matcher)Matchers.is((Object)4));
        MatcherAssert.assertThat((Object)((LoggingEvent)this.logger.getAllLoggingEvents().get(0)), (Matcher)LogMatcher.logMatches((LoggingEvent)new LoggingEvent(Level.DEBUG, "Received new SLAs: {}", new Object[]{Arrays.asList(this.sla(1902))})));
        MatcherAssert.assertThat((Object)((LoggingEvent)this.logger.getAllLoggingEvents().get(1)), (Matcher)LogMatcher.logMatches((LoggingEvent)new LoggingEvent(Level.DEBUG, "The following SLAs were modified: {}", new Object[]{Collections.emptyList()})));
        MatcherAssert.assertThat((Object)((LoggingEvent)this.logger.getAllLoggingEvents().get(2)), (Matcher)LogMatcher.logMatches((LoggingEvent)new LoggingEvent(Level.DEBUG, "The following SLAs were not modified: {}", new Object[]{Arrays.asList(this.sla(1))})));
        MatcherAssert.assertThat((Object)((LoggingEvent)this.logger.getAllLoggingEvents().get(3)), (Matcher)LogMatcher.logMatches((LoggingEvent)new LoggingEvent(Level.DEBUG, "The following SLAs were not returned by the platform: {}", new Object[]{Collections.emptyList()})));
    }

    @Test
    public void slaNotReturnedByPlatformdIsLogged() {
        ContractSnapshot snapshot = new ContractSnapshot(Arrays.asList(this.contractSingleLimit(1)), (ClientFactory)new DefaultClientFactory());
        snapshot.platformSlas(Collections.emptyList());
        MatcherAssert.assertThat((Object)this.logger.getAllLoggingEvents().size(), (Matcher)Matchers.is((Object)4));
        MatcherAssert.assertThat((Object)((LoggingEvent)this.logger.getAllLoggingEvents().get(0)), (Matcher)LogMatcher.logMatches((LoggingEvent)new LoggingEvent(Level.DEBUG, "Received new SLAs: {}", new Object[]{Collections.emptyList()})));
        MatcherAssert.assertThat((Object)((LoggingEvent)this.logger.getAllLoggingEvents().get(1)), (Matcher)LogMatcher.logMatches((LoggingEvent)new LoggingEvent(Level.DEBUG, "The following SLAs were modified: {}", new Object[]{Collections.emptyList()})));
        MatcherAssert.assertThat((Object)((LoggingEvent)this.logger.getAllLoggingEvents().get(2)), (Matcher)LogMatcher.logMatches((LoggingEvent)new LoggingEvent(Level.DEBUG, "The following SLAs were not modified: {}", new Object[]{Collections.emptyList()})));
        MatcherAssert.assertThat((Object)((LoggingEvent)this.logger.getAllLoggingEvents().get(3)), (Matcher)LogMatcher.logMatches((LoggingEvent)new LoggingEvent(Level.DEBUG, "The following SLAs were not returned by the platform: {}", new Object[]{Arrays.asList(this.sla(1))})));
    }

    @Test
    public void addContractToNewSnapshot() {
        ContractSnapshot snapshot = new ContractSnapshot((ClientFactory)new DefaultClientFactory());
        snapshot.platformContracts(Arrays.asList(this.platformContractAdapter(1), this.anotherPlatformContractAdapter(1902)));
        MatcherAssert.assertThat((Object)this.logger.getAllLoggingEvents().size(), (Matcher)Matchers.is((Object)3));
        MatcherAssert.assertThat((Object)((LoggingEvent)this.logger.getAllLoggingEvents().get(0)), (Matcher)LogMatcher.logMatches((LoggingEvent)new LoggingEvent(Level.DEBUG, "Received new Contracts: {}", new Object[]{Arrays.asList(this.contractNoTier(1), this.contract(this.noTierSla(1902), this.anotherClient(1902)))})));
        MatcherAssert.assertThat((Object)((LoggingEvent)this.logger.getAllLoggingEvents().get(1)), (Matcher)LogMatcher.logMatches((LoggingEvent)new LoggingEvent(Level.DEBUG, "The following Contracts were modified: {}", new Object[]{Collections.emptyList()})));
        MatcherAssert.assertThat((Object)((LoggingEvent)this.logger.getAllLoggingEvents().get(2)), (Matcher)LogMatcher.logMatches((LoggingEvent)new LoggingEvent(Level.DEBUG, "The following Contracts were removed: {}", new Object[]{Collections.emptyList()})));
    }

    @Test
    public void modifySingleContractIsLogged() {
        ContractSnapshot snapshot = new ContractSnapshot(Arrays.asList(this.contractSingleLimit(1)), (ClientFactory)new DefaultClientFactory());
        snapshot.platformContracts(Arrays.asList(this.platformContractAdapter(1902)));
        MatcherAssert.assertThat((Object)this.logger.getAllLoggingEvents().size(), (Matcher)Matchers.is((Object)3));
        MatcherAssert.assertThat((Object)((LoggingEvent)this.logger.getAllLoggingEvents().get(0)), (Matcher)LogMatcher.logMatches((LoggingEvent)new LoggingEvent(Level.DEBUG, "Received new Contracts: {}", new Object[]{Collections.emptyList()})));
        MatcherAssert.assertThat((Object)((LoggingEvent)this.logger.getAllLoggingEvents().get(1)), (Matcher)LogMatcher.logMatches((LoggingEvent)new LoggingEvent(Level.DEBUG, "The following Contracts were modified: {}", new Object[]{Arrays.asList(this.contractNoTier(1902))})));
        MatcherAssert.assertThat((Object)((LoggingEvent)this.logger.getAllLoggingEvents().get(2)), (Matcher)LogMatcher.logMatches((LoggingEvent)new LoggingEvent(Level.DEBUG, "The following Contracts were removed: {}", new Object[]{Collections.emptyList()})));
    }

    @Test
    public void addAndModifyContractsIsLogged() {
        ContractSnapshot snapshot = new ContractSnapshot(Arrays.asList(this.contractSingleLimit(1)), (ClientFactory)new DefaultClientFactory());
        snapshot.platformContracts(Arrays.asList(this.platformContractAdapter(1902), this.anotherPlatformContractAdapter(1)));
        MatcherAssert.assertThat((Object)this.logger.getAllLoggingEvents().size(), (Matcher)Matchers.is((Object)3));
        MatcherAssert.assertThat((Object)((LoggingEvent)this.logger.getAllLoggingEvents().get(0)), (Matcher)LogMatcher.logMatches((LoggingEvent)new LoggingEvent(Level.DEBUG, "Received new Contracts: {}", new Object[]{Arrays.asList(this.contract(this.noTierSla(1), this.anotherClient(1)))})));
        MatcherAssert.assertThat((Object)((LoggingEvent)this.logger.getAllLoggingEvents().get(1)), (Matcher)LogMatcher.logMatches((LoggingEvent)new LoggingEvent(Level.DEBUG, "The following Contracts were modified: {}", new Object[]{Arrays.asList(this.contractNoTier(1902))})));
        MatcherAssert.assertThat((Object)((LoggingEvent)this.logger.getAllLoggingEvents().get(2)), (Matcher)LogMatcher.logMatches((LoggingEvent)new LoggingEvent(Level.DEBUG, "The following Contracts were removed: {}", new Object[]{Collections.emptyList()})));
    }

    @Test
    public void removeContractsIsLogged() {
        ContractSnapshot snapshot = new ContractSnapshot(Arrays.asList(this.contractSingleLimit(1)), (ClientFactory)new DefaultClientFactory());
        snapshot.platformContracts(Collections.emptyList());
        MatcherAssert.assertThat((Object)this.logger.getAllLoggingEvents().size(), (Matcher)Matchers.is((Object)3));
        MatcherAssert.assertThat((Object)((LoggingEvent)this.logger.getAllLoggingEvents().get(0)), (Matcher)LogMatcher.logMatches((LoggingEvent)new LoggingEvent(Level.DEBUG, "Received new Contracts: {}", new Object[]{Collections.emptyList()})));
        MatcherAssert.assertThat((Object)((LoggingEvent)this.logger.getAllLoggingEvents().get(1)), (Matcher)LogMatcher.logMatches((LoggingEvent)new LoggingEvent(Level.DEBUG, "The following Contracts were modified: {}", new Object[]{Collections.emptyList()})));
        MatcherAssert.assertThat((Object)((LoggingEvent)this.logger.getAllLoggingEvents().get(2)), (Matcher)LogMatcher.logMatches((LoggingEvent)new LoggingEvent(Level.DEBUG, "The following Contracts were removed: {}", new Object[]{Arrays.asList(this.contractSingleLimit(1))})));
    }
}

