/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.autodiscovery.api.config;

import org.mule.runtime.dsl.api.xml.XmlNamespaceInfo;
import org.mule.runtime.dsl.api.xml.XmlNamespaceInfoProvider;

import com.google.common.collect.Lists;

import java.util.Collection;

public class ApiGatewayXmlNamespaceInfoProvider implements XmlNamespaceInfoProvider {

  public static final String API_PLATFORM_GW_NAMESPACE = "api-gateway";

  @Override
  public Collection<XmlNamespaceInfo> getXmlNamespacesInfo() {
    return Lists.newArrayList(new XmlNamespaceInfo() {

      @Override
      public String getNamespaceUriPrefix() {
        return "http://www.mulesoft.org/schema/mule/api-gateway";
      }

      @Override
      public String getNamespace() {
        return API_PLATFORM_GW_NAMESPACE;
      }
    });
  }
}
