/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.autodiscovery.api.config;

import static com.mulesoft.mule.runtime.gw.autodiscovery.internal.AutodiscoveryExtensionModelProvider.getExtensionModel;
import static java.util.Collections.singleton;
import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.core.Is.is;
import static org.junit.Assert.assertThat;

import org.mule.functional.junit4.FunctionalTestCase;
import org.mule.runtime.core.api.config.ConfigurationBuilder;

import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.mule.runtime.gw.autodiscovery.ByIdAutodiscovery;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;

import org.junit.Test;

public class AutoDiscoveryConfigurationTestCase extends FunctionalTestCase {

  @Override
  protected String getConfigFile() {
    return "mule-autodiscovery-config.xml";
  }

  @Override
  protected boolean doTestClassInjection() {
    return true;
  }

  @Override
  protected void addBuilders(List<ConfigurationBuilder> builders) {
    super.addBuilders(builders);
    builders.add(extensionManagerWithMuleExtModelBuilder(singleton(getExtensionModel())));
  }

  @Test
  public void autoDiscoveryConfiguration() {
    Collection<ByIdAutodiscovery> apiMetadatas = registry.lookupAllByType(ByIdAutodiscovery.class);

    assertThat(apiMetadatas, hasSize(4));
    Iterator<ByIdAutodiscovery> iterator = apiMetadatas.iterator();
    ByIdAutodiscovery apiMetadata = iterator.next();
    assertThat(apiMetadata.getId(), is(1L));
    assertThat(apiMetadata.getApiKey(), is(new ApiKey(1L)));
    assertThat(apiMetadata.getFlow().getName(), is("flow_api"));
    assertThat(apiMetadata.isIgnoreBasePath(), is(true));

    ByIdAutodiscovery apiMetadata2 = iterator.next();
    assertThat(apiMetadata2.getId(), is(2L));
    assertThat(apiMetadata2.getApiKey(), is(new ApiKey(2L)));
    assertThat(apiMetadata2.getFlow().getName(), is("flow_api_2"));
    assertThat(apiMetadata2.isIgnoreBasePath(), is(true));

    ByIdAutodiscovery apiMetadata3 = iterator.next();
    assertThat(apiMetadata3.getId(), is(3L));
    assertThat(apiMetadata3.getApiKey(), is(new ApiKey(3L)));
    assertThat(apiMetadata3.getFlow().getName(), is("flow_api_3"));
    assertThat(apiMetadata3.isIgnoreBasePath(), is(false));

    ByIdAutodiscovery apiMetadata4 = iterator.next();
    assertThat(apiMetadata4.getId(), is(4L));
    assertThat(apiMetadata4.getApiKey(), is(new ApiKey(4L)));
    assertThat(apiMetadata4.getFlow().getName(), is("flow_api_4"));
    assertThat(apiMetadata4.isIgnoreBasePath(), is(true));
  }
}

