/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.autodiscovery;

import static com.mulesoft.mule.runtime.gw.api.annotations.GatewayAppAnnotations.IGNORE_BASE_PATH_ANNOTATION;
import static java.lang.Boolean.parseBoolean;

import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.core.api.construct.Flow;

import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.mule.runtime.gw.autodiscovery.api.Autodiscovery;

public class ByIdAutodiscovery extends AbstractComponent implements Autodiscovery {

  private Long id;
  private Flow flow;
  private boolean ignoreBasePath;

  @Override
  public ApiKey getApiKey() {
    return new ApiKey(id);
  }

  @Override
  public Flow getFlow() {
    return flow;
  }

  @Override
  public boolean isIgnoreBasePath() {
    Object annotation = getAnnotation(IGNORE_BASE_PATH_ANNOTATION);
    return ignoreBasePath || (annotation != null && parseBoolean((String) annotation));
  }

  public void setFlow(Flow flow) {
    this.flow = flow;
  }

  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  public void setIgnoreBasePath(boolean ignoreBasePath) {
    this.ignoreBasePath = ignoreBasePath;
  }
}
