/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.autodiscovery.api.config;

import static org.mule.runtime.dsl.api.component.AttributeDefinition.Builder.fromSimpleParameter;
import static org.mule.runtime.dsl.api.component.AttributeDefinition.Builder.fromSimpleReferenceParameter;
import static org.mule.runtime.dsl.api.component.TypeDefinition.fromType;

import org.mule.runtime.dsl.api.component.ComponentBuildingDefinition;
import org.mule.runtime.dsl.api.component.ComponentBuildingDefinitionProvider;
import com.mulesoft.mule.runtime.gw.autodiscovery.ByIdAutodiscovery;

import java.util.LinkedList;
import java.util.List;

public class ApiGatewayComponentBuildingDefinitionProvider implements ComponentBuildingDefinitionProvider {

  public static final String API = "autodiscovery";

  public static final String PARAMETER_ID = "apiId";
  public static final String PARAMETER_FLOW = "flowRef";
  public static final String IGNORE_BASE_PATH = "ignoreBasePath";

  private ComponentBuildingDefinition.Builder baseDefinition;

  @Override
  public void init() {
    baseDefinition =
        new ComponentBuildingDefinition.Builder()
            .withNamespace(ApiGatewayXmlNamespaceInfoProvider.API_PLATFORM_GW_NAMESPACE);
  }

  @Override
  public List<ComponentBuildingDefinition> getComponentBuildingDefinitions() {
    List<ComponentBuildingDefinition> componentBuildingDefinitions = new LinkedList<>();

    componentBuildingDefinitions.add(baseDefinition
        .withIdentifier(API)
        .withTypeDefinition(fromType(ByIdAutodiscovery.class))
        .withSetterParameterDefinition("id", fromSimpleParameter(PARAMETER_ID).build())
        .withSetterParameterDefinition("flow", fromSimpleReferenceParameter(PARAMETER_FLOW).build())
        .withSetterParameterDefinition("ignoreBasePath", fromSimpleParameter(IGNORE_BASE_PATH).build())
        .build());

    return componentBuildingDefinitions;
  }

}
