/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.autodiscovery.internal;

import static com.mulesoft.mule.runtime.gw.autodiscovery.api.config.ApiGatewayComponentBuildingDefinitionProvider.API;
import static com.mulesoft.mule.runtime.gw.autodiscovery.api.config.ApiGatewayComponentBuildingDefinitionProvider.IGNORE_BASE_PATH;
import static com.mulesoft.mule.runtime.gw.autodiscovery.api.config.ApiGatewayComponentBuildingDefinitionProvider.PARAMETER_FLOW;
import static com.mulesoft.mule.runtime.gw.autodiscovery.api.config.ApiGatewayComponentBuildingDefinitionProvider.PARAMETER_ID;
import static com.mulesoft.mule.runtime.gw.autodiscovery.api.config.ApiGatewayXmlNamespaceInfoProvider.API_PLATFORM_GW_NAMESPACE;
import static com.mulesoft.mule.runtime.gw.autodiscovery.api.config.ApiGatewayXmlNamespaceInfoProvider.API_PLATFORM_GW_NAMESPACE_URI;
import static org.mule.runtime.api.meta.Category.SELECT;
import static org.mule.runtime.api.meta.ExpressionSupport.NOT_SUPPORTED;
import static org.mule.runtime.core.api.extension.MuleExtensionModelProvider.BOOLEAN_TYPE;
import static org.mule.runtime.core.api.extension.MuleExtensionModelProvider.MULE_VERSION;
import static org.mule.runtime.core.api.extension.MuleExtensionModelProvider.STRING_TYPE;
import static org.mule.runtime.extension.api.util.XmlModelUtils.buildSchemaLocation;

import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterGroupDeclarer;
import org.mule.runtime.core.internal.extension.CustomBuildingDefinitionProviderModelProperty;

/**
 * An {@link ExtensionDeclarer} for API Gateway's Autodiscovery components.
 *
 * @since 4.4
 */
public class AutodiscoveryExtensionModelDeclarer {

  public ExtensionDeclarer createExtensionModel() {
    ExtensionDeclarer extensionDeclarer = new ExtensionDeclarer()
        .named(API_PLATFORM_GW_NAMESPACE)
        .describedAs("Mule Runtime and Integration Platform: API Gateway Autodiscovery components")
        .onVersion(MULE_VERSION)
        .fromVendor("MuleSoft, Inc.")
        .withCategory(SELECT)
        .withModelProperty(new CustomBuildingDefinitionProviderModelProperty())
        .withXmlDsl(XmlDslModel.builder()
            .setPrefix(API_PLATFORM_GW_NAMESPACE)
            .setNamespace(API_PLATFORM_GW_NAMESPACE_URI)
            .setSchemaVersion(MULE_VERSION)
            .setXsdFileName("mule-api-gateway.xsd")
            .setSchemaLocation(buildSchemaLocation(API_PLATFORM_GW_NAMESPACE, API_PLATFORM_GW_NAMESPACE_URI))
            .build());

    ParameterGroupDeclarer declarer = extensionDeclarer.withConstruct(API)
        .allowingTopLevelDefinition()
        .describedAs("API definition to be used in conjunction with the flow using the flowRef attribute.")
        .onDefaultParameterGroup();

    declarer.withRequiredParameter(PARAMETER_ID)
        .describedAs("The id of the API in API Manager.")
        .withExpressionSupport(NOT_SUPPORTED)
        .ofType(STRING_TYPE);

    declarer.withRequiredParameter(PARAMETER_FLOW)
        .describedAs("A reference to the Flow configuration. This replaces the use of the register-as element.")
        .withExpressionSupport(NOT_SUPPORTED)
        .ofType(STRING_TYPE);

    declarer.withOptionalParameter(IGNORE_BASE_PATH)
        .describedAs("When a resource level policy is applied to the API, the incoming HTTP request's path is used to check"
            + "whether the policy has to be applied to that request. This attribute allows to specify if the full"
            + "path of the request needs to be used (everything to the right of the host:port part of the URL) or the"
            + "base path where the API is deployed should be ignored (the path that replaces the wildcard part of the"
            + "HTTP Listener). Note that this attribute is ignored if {@code listenerPath} is not open (ends with a"
            + "wildcard) and will be false otherwise since base path can not be calculated.")
        .withExpressionSupport(NOT_SUPPORTED)
        .ofType(BOOLEAN_TYPE)
        .defaultingTo(false);


    return extensionDeclarer;
  }

}
