/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.autodiscovery;

import static java.util.stream.Collectors.toList;

import org.mule.runtime.api.artifact.Registry;

import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.mule.runtime.gw.autodiscovery.api.Autodiscovery;

import java.util.ArrayList;
import java.util.Collection;

/**
 * Discover the application's API data using the DeploymentService
 */
public class ApiDiscovery {

  public Collection<ApiKey> apiKeys(Registry registry) {
    return discoverAPIKeys(autoDiscoveryMetadatas(registry));
  }

  public Collection<Autodiscovery> autoDiscoveryMetadatas(Registry registry) {
    return registry != null ? registry.lookupAllByType(Autodiscovery.class) : new ArrayList<>();
  }

  private Collection<ApiKey> discoverAPIKeys(Collection<Autodiscovery> byIdAutoDiscoveries) {
    return byIdAutoDiscoveries
        .stream()
        .map(Autodiscovery::getApiKey)
        .collect(toList());
  }
}
