/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.autodiscovery.api;

import org.mule.runtime.api.component.Component;
import org.mule.runtime.core.api.construct.Flow;

import com.mulesoft.mule.runtime.gw.api.key.ApiKey;

public interface Autodiscovery extends Component {

  /**
   * @return the identification of the API
   */
  ApiKey getApiKey();

  /**
   * @return the flow where the API is implemented
   */
  Flow getFlow();

  /**
   *
   * @return whether the full path of the request needs to be used (everything to the right of the host:port part of the URL) or
   *         the base path where the API is deployed should be ignored (the path that replaces the wildcard part of the HTTP
   *         Listener) when matching resource level policies against an incoming request.
   *
   * @since 4.3
   */
  default boolean isIgnoreBasePath() {
    return false;
  }
}
