/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.hdp.listener;

import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.component.ConfigurationProperties;
import org.mule.runtime.module.deployment.api.DeploymentListener;
import org.mule.runtime.module.deployment.api.DeploymentService;

import com.mulesoft.mule.runtime.gw.deployment.ApiService;
import com.mulesoft.mule.runtime.gw.hdp.config.HighDensityProxyConfiguration;
import com.mulesoft.mule.runtime.gw.hdp.registry.ApiRegistryWatcher;
import com.mulesoft.mule.runtime.gw.logging.GatewayMuleAppLoggerFactory;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

import org.slf4j.Logger;

public class HdpDeploymentListener implements DeploymentListener {

  private final ApiService apiService;
  private final DeploymentService deploymentService;
  private final List<ApiRegistryWatcher> apiRegistryWatchers = new ArrayList<>();
  private final HighDensityProxyConfiguration hdpConfiguration = new HighDensityProxyConfiguration();

  private static final Logger LOGGER = GatewayMuleAppLoggerFactory.getLogger(HdpDeploymentListener.class);

  public HdpDeploymentListener(ApiService apiService, DeploymentService deploymentService) {
    this.apiService = apiService;
    this.deploymentService = deploymentService;
  }

  @Override
  public void onDeploymentSuccess(String artifactName) {
    if (isHighDensityProxy(deploymentService.findApplication(artifactName).getRegistry())) {
      ApiRegistryWatcher apiRegistryWatcher = new ApiRegistryWatcher(apiService, artifactName);
      apiRegistryWatchers.add(apiRegistryWatcher);
      try {
        apiRegistryWatcher.initialise();
        apiRegistryWatcher.start();
      } catch (Exception e) {
        LOGGER.error(String.format("Error starting High Density Proxy registry monitor for artifact %s", artifactName), e);
      }
    }
  }

  @Override
  public void onUndeploymentStart(String artifactName) {
    apiRegistryWatchers.stream().filter(arw -> arw.getArtifactName().equals(artifactName)).findFirst()
        .ifPresent(ApiRegistryWatcher::stop);
  }

  public boolean isHighDensityProxy(Registry registry) {
    if (registry != null) {
      Optional<ConfigurationProperties> configurationProperties = registry.lookupByType(ConfigurationProperties.class);
      if (configurationProperties != null && configurationProperties.isPresent()) {
        Optional<Boolean> hdp =
            configurationProperties.get().resolveBooleanProperty(hdpConfiguration.getHdpApplicationProperty());
        return hdp.orElse(false);
      }
    }
    return false;
  }

}
