/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.hdp.config;

import static org.junit.Assert.assertEquals;

import org.junit.After;
import org.junit.Test;

public class HighDensityProxyConfigurationTestCase {

  private HighDensityProxyConfiguration configuration = new HighDensityProxyConfiguration();

  @After
  public void tearDown() {
    System.clearProperty("anypoint.platform.hdp_application_property");
    System.clearProperty("anypoint.platform.hdp_service_header");
  }

  @Test
  public void applicationPropertyDefaultValue() {
    String applicationProperty = configuration.getHdpApplicationProperty();
    assertEquals(applicationProperty, "agw.hdp");
  }

  @Test
  public void applicationPropertyValue() {
    String customHdpProperty = "custom-hdp-prop";
    System.setProperty("anypoint.platform.hdp_application_property", customHdpProperty);
    String applicationProperty = configuration.getHdpApplicationProperty();
    assertEquals(applicationProperty, customHdpProperty);
  }

  @Test
  public void serviceHeaderDefaultValue() {
    String serviceHeader = configuration.getHdpServiceHeader();
    assertEquals(serviceHeader, "X-MULE-HDP-SERVICE");
  }

  @Test
  public void serviceHeaderPropertyValue() {
    String customHeader = "custom-hdp-service-header";
    System.setProperty("anypoint.platform.hdp_service_header", customHeader);
    String serviceHeader = configuration.getHdpServiceHeader();
    assertEquals(serviceHeader, customHeader);
  }

}
