/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.hdp.listener;

import static java.util.Optional.empty;
import static java.util.Optional.of;
import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.is;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertThat;
import static org.junit.Assert.assertTrue;
import static org.mockito.Mockito.RETURNS_DEEP_STUBS;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.when;

import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.component.ConfigurationProperties;
import org.mule.runtime.deployment.model.api.application.Application;
import org.mule.runtime.module.deployment.api.DeploymentService;

import com.mulesoft.mule.runtime.gw.deployment.ApiService;
import com.mulesoft.mule.runtime.gw.hdp.config.HighDensityProxyConfiguration;
import com.mulesoft.mule.runtime.gw.hdp.registry.ApiRegistryWatcher;
import com.mulesoft.mule.runtime.gw.reflection.Inspector;

import java.util.List;

import org.junit.Before;
import org.junit.Test;

public class HdpDeploymentListenerTestCase {

  private DeploymentService deploymentService;
  private ApiService apiService;
  private HdpDeploymentListener hdpDeploymentListener;

  private HighDensityProxyConfiguration hdpConfiguration = new HighDensityProxyConfiguration();

  private static final String HDP_APP = "service-mesh";

  @Before
  public void setUp() {
    deploymentService = mock(DeploymentService.class);
    apiService = mock(ApiService.class);
    hdpDeploymentListener = new HdpDeploymentListener(apiService, deploymentService);
  }

  @Test
  public void isHighDensityProxy() {
    ConfigurationProperties config = mock(ConfigurationProperties.class);
    when(config.resolveBooleanProperty(hdpConfiguration.getHdpApplicationProperty())).thenReturn(of(true));
    Registry hdpRegistry = mock(Registry.class);
    when(hdpRegistry.lookupByType(ConfigurationProperties.class)).thenReturn(of(config));

    assertTrue(hdpDeploymentListener.isHighDensityProxy(hdpRegistry));

    when(config.resolveBooleanProperty(hdpConfiguration.getHdpApplicationProperty())).thenReturn(empty());
    assertFalse(hdpDeploymentListener.isHighDensityProxy(hdpRegistry));

    when(hdpRegistry.lookupByType(ConfigurationProperties.class)).thenReturn(empty());
    assertFalse(hdpDeploymentListener.isHighDensityProxy(hdpRegistry));
  }

  @Test
  public void onHdpDeploymentSuccess() {
    injectHdpApplication();
    hdpDeploymentListener.onDeploymentSuccess(HDP_APP);

    List<ApiRegistryWatcher> watchers = getHdpRegistryWatchers();
    assertThat(watchers, hasSize(1));
    assertThat(new Inspector(watchers.get(0)).read("artifactName"), is(HDP_APP));
  }

  private List<ApiRegistryWatcher> getHdpRegistryWatchers() {
    return new Inspector(hdpDeploymentListener).read("apiRegistryWatchers");
  }

  private Application injectHdpApplication() {
    Application application = mock(Application.class, RETURNS_DEEP_STUBS);
    when(deploymentService.findApplication(HDP_APP)).thenReturn(application);
    when(application.getArtifactName()).thenReturn(HDP_APP);

    ConfigurationProperties config = mock(ConfigurationProperties.class);
    when(config.resolveBooleanProperty(hdpConfiguration.getHdpApplicationProperty())).thenReturn(of(true));
    when(application.getRegistry().lookupByType(ConfigurationProperties.class)).thenReturn(of(config));
    return application;
  }

}
