/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.hdp.registry;

import com.mulesoft.mule.runtime.gw.deployment.ApiService;
import com.mulesoft.mule.runtime.gw.model.hdp.ApiRegistry;
import com.mulesoft.mule.runtime.gw.model.hdp.ApiRegistryException;

import java.io.File;
import java.util.ArrayList;

import org.apache.commons.io.monitor.FileAlterationListenerAdaptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiRegistryListener extends FileAlterationListenerAdaptor {

  private static final Logger LOGGER = LoggerFactory.getLogger(ApiRegistryListener.class);
  private final ApiService apiService;
  private String appName;

  public ApiRegistryListener(ApiService apiService, String appName) {
    this.apiService = apiService;
    this.appName = appName;
  }

  @Override
  public void onFileCreate(File file) {
    LOGGER.info("file created " + file);
    try {
      apiService.updateHdpApis(ApiRegistry.fromFile(appName, file));
    } catch (ApiRegistryException e) {
      // no changes applied, exception already logged
    }
  }

  @Override
  public void onFileChange(File file) {
    LOGGER.info("file changed " + file);
    try {
      apiService.updateHdpApis(ApiRegistry.fromFile(appName, file));
    } catch (ApiRegistryException e) {
      // no changes applied, exception already logged
    }
  }

  @Override
  public void onFileDelete(File file) {
    LOGGER.info("file deleted " + file);
    apiService.updateHdpApis(new ApiRegistry(appName, new ArrayList<>()));
  }

}
