/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.hdp.listener;

import com.mulesoft.mule.runtime.gw.deployment.ApiService;
import com.mulesoft.mule.runtime.gw.hdp.config.HighDensityProxyConfiguration;
import com.mulesoft.mule.runtime.gw.hdp.registry.ApiRegistryWatcher;
import com.mulesoft.mule.runtime.gw.logging.GatewayMuleAppLoggerFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.component.ConfigurationProperties;
import org.mule.runtime.module.deployment.api.DeploymentListener;
import org.mule.runtime.module.deployment.api.DeploymentService;
import org.slf4j.Logger;

public class HdpDeploymentListener
implements DeploymentListener {
    private final ApiService apiService;
    private final DeploymentService deploymentService;
    private final List<ApiRegistryWatcher> apiRegistryWatchers = new ArrayList<ApiRegistryWatcher>();
    private final HighDensityProxyConfiguration hdpConfiguration = new HighDensityProxyConfiguration();
    private static final Logger LOGGER = GatewayMuleAppLoggerFactory.getLogger(HdpDeploymentListener.class);

    public HdpDeploymentListener(ApiService apiService, DeploymentService deploymentService) {
        this.apiService = apiService;
        this.deploymentService = deploymentService;
    }

    public void onDeploymentSuccess(String artifactName) {
        if (this.isHighDensityProxy(this.deploymentService.findApplication(artifactName).getRegistry())) {
            ApiRegistryWatcher apiRegistryWatcher = new ApiRegistryWatcher(this.apiService, artifactName);
            this.apiRegistryWatchers.add(apiRegistryWatcher);
            try {
                apiRegistryWatcher.initialise();
                apiRegistryWatcher.start();
            }
            catch (Exception e) {
                LOGGER.error(String.format("Error starting High Density Proxy registry monitor for artifact %s", artifactName), (Throwable)e);
            }
        }
    }

    public void onUndeploymentStart(String artifactName) {
        this.apiRegistryWatchers.stream().filter(arw -> arw.getArtifactName().equals(artifactName)).findFirst().ifPresent(ApiRegistryWatcher::stop);
    }

    public boolean isHighDensityProxy(Registry registry) {
        Optional configurationProperties;
        if (registry != null && (configurationProperties = registry.lookupByType(ConfigurationProperties.class)) != null && configurationProperties.isPresent()) {
            Optional hdp = ((ConfigurationProperties)configurationProperties.get()).resolveBooleanProperty(this.hdpConfiguration.getHdpApplicationProperty());
            return hdp.orElse(false);
        }
        return false;
    }
}

