/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.hdp.config;

import static java.lang.System.getProperty;
import static org.apache.commons.lang3.StringUtils.trimToNull;

import com.mulesoft.mule.runtime.gw.api.config.RuntimeConfiguration;

public class HighDensityProxyConfiguration extends RuntimeConfiguration {

  /**
   * The name of the application level configuration property that indicates that the application works in HDP mode
   */
  private static final String HDP_APPLICATION_PROPERTY = "anypoint.platform.hdp_application_property";
  private static final String HDP_APPLICATION_PROPERTY_DEFAULT = "agw.hdp";

  /**
   * The request header to be used to obtain the service name that maps to an apiID
   */
  private static final String HDP_SERVICE_HEADER = "anypoint.platform.hdp_service_header";
  private static final String HDP_SERVICE_HEADER_DEFAULT = "X-MULE-HDP-SERVICE";

  public String getHdpApplicationProperty() {
    return trimToNull(getProperty(HDP_APPLICATION_PROPERTY, HDP_APPLICATION_PROPERTY_DEFAULT));
  }

  public String getHdpServiceHeader() {
    return trimToNull(getProperty(HDP_SERVICE_HEADER, HDP_SERVICE_HEADER_DEFAULT));
  }

}
