/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.hdp.registry;

import com.mulesoft.mule.runtime.gw.deployment.api.ApiService;
import com.mulesoft.mule.runtime.gw.model.hdp.ApiRegistry;
import com.mulesoft.mule.runtime.gw.model.hdp.ApiRegistryException;
import java.io.File;
import java.util.ArrayList;
import org.apache.commons.io.monitor.FileAlterationListenerAdaptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiRegistryListener
extends FileAlterationListenerAdaptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApiRegistryListener.class);
    private final ApiService apiService;
    private String appName;

    public ApiRegistryListener(ApiService apiService, String appName) {
        this.apiService = apiService;
        this.appName = appName;
    }

    public void onFileCreate(File file) {
        LOGGER.info("file created " + file);
        try {
            this.apiService.updateHdpApis(ApiRegistry.fromFile((String)this.appName, (File)file));
        }
        catch (ApiRegistryException apiRegistryException) {
            // empty catch block
        }
    }

    public void onFileChange(File file) {
        LOGGER.info("file changed " + file);
        try {
            this.apiService.updateHdpApis(ApiRegistry.fromFile((String)this.appName, (File)file));
        }
        catch (ApiRegistryException apiRegistryException) {
            // empty catch block
        }
    }

    public void onFileDelete(File file) {
        LOGGER.info("file deleted " + file);
        this.apiService.updateHdpApis(new ApiRegistry(this.appName, new ArrayList()));
    }
}

