/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.metrics.event.information;

import com.mulesoft.mule.runtime.gw.metrics.event.Event;
import com.mulesoft.mule.runtime.gw.metrics.event.EventVisitor;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.Objects;

public class GatewayInformation extends Event {

  private static final long serialVersionUID = -8062965982399373204L;

  @JsonProperty(value = "runtime_version")
  private String runtimeVersion;

  @JsonProperty(value = "deployment_target")
  private String deploymentTarget;

  @JsonProperty(value = "gatekeeper_mode")
  private String gatekeeperMode;

  @JsonProperty(value = "cluster_enabled")
  private boolean clusterMode;

  @JsonProperty(value = "security")
  private GatewaySecurityInformation gatewaySecurityInformation;

  @JsonProperty(value = "platform")
  private PlatformInformation platformInformation;

  @JsonProperty(value = "analytics")
  private AnalyticsInformation analyticsInformation;


  public GatewayInformation() {}

  public GatewayInformation(String runtimeVersion, String deploymentTarget, String gatekeeperMode,
                            boolean clusterMode, GatewaySecurityInformation gatewaySecurityInformation,
                            PlatformInformation platformInformation, AnalyticsInformation analyticsInformation, long time) {
    super(time);
    this.runtimeVersion = runtimeVersion;
    this.deploymentTarget = deploymentTarget;
    this.gatekeeperMode = gatekeeperMode;
    this.clusterMode = clusterMode;
    this.gatewaySecurityInformation = gatewaySecurityInformation;
    this.platformInformation = platformInformation;
    this.analyticsInformation = analyticsInformation;
  }

  @Override
  public <T> T accept(EventVisitor<T> visitor) {
    return visitor.visit(this);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }

    if (o == null || getClass() != o.getClass()) {
      return false;
    }

    GatewayInformation gatewayInformation = (GatewayInformation) o;
    return runtimeVersion.equals(gatewayInformation.runtimeVersion) &&
        deploymentTarget.equals(gatewayInformation.deploymentTarget) &&
        gatekeeperMode.equals(gatewayInformation.gatekeeperMode) &&
        clusterMode == gatewayInformation.clusterMode &&
        gatewaySecurityInformation.equals(gatewayInformation.gatewaySecurityInformation) &&
        platformInformation.equals(gatewayInformation.platformInformation) &&
        analyticsInformation.equals(gatewayInformation.analyticsInformation);
  }

  @Override
  public int hashCode() {
    return Objects.hash(runtimeVersion, deploymentTarget, gatekeeperMode, clusterMode,
                        gatewaySecurityInformation.hashCode(), platformInformation.hashCode(), analyticsInformation.hashCode());
  }

  @Override
  public String toString() {
    return "{" + "runtimeVersion=" + runtimeVersion + ", deploymentTarget=" + deploymentTarget
        + ", gatekeeperMode=" + gatekeeperMode + ", clusterMode=" + clusterMode + ", gatewaySecurityInformation="
        + gatewaySecurityInformation + ", platformInformation=" + platformInformation + ", analyticsInformation="
        + analyticsInformation + '}';
  }

}
