/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.metrics.event.status;

import com.mulesoft.mule.runtime.gw.metrics.event.Event;
import com.mulesoft.mule.runtime.gw.metrics.event.EventVisitor;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;
import java.util.Objects;

public class GatewayStatus extends Event {

  private static final long serialVersionUID = 4470768789390981242L;

  @JsonProperty(value = "applications")
  private List<AppStatus> apps;

  public GatewayStatus() {}

  public GatewayStatus(List<AppStatus> apps, long time) {
    super(time);
    this.apps = apps;
  }

  @Override
  public <T> T accept(EventVisitor<T> visitor) {
    return visitor.visit(this);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }

    if (o == null || getClass() != o.getClass()) {
      return false;
    }

    GatewayStatus that = (GatewayStatus) o;
    return apps.equals(that.apps);
  }

  @Override
  public int hashCode() {
    return Objects.hash(apps);
  }

  @Override
  public String toString() {
    return "{" + "applications=" + apps + ", time=" + time + '}';
  }
}
