/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.metrics.event.status;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

public class PolicyStatus implements Comparable<PolicyStatus>, Serializable {

  private static final long serialVersionUID = 5963726567350000476L;

  @JsonProperty
  private Integer order;

  @JsonProperty(value = "policy_id")
  private String policyId;

  @JsonProperty
  private String gav;

  @JsonProperty(value = "online")
  private boolean isOnline;

  public PolicyStatus() {}

  public PolicyStatus(Integer order, String policyId, String gav, boolean isOnline) {
    this.order = order;
    this.policyId = policyId;
    this.gav = gav;
    this.isOnline = isOnline;
  }

  @Override
  public int compareTo(PolicyStatus o) {
    int compareResult = order.compareTo(o.order);
    return compareResult == 0 ? policyId.compareTo(o.policyId) : compareResult;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }

    if (o == null || getClass() != o.getClass()) {
      return false;
    }

    PolicyStatus that = (PolicyStatus) o;
    return isOnline == that.isOnline &&
        order.equals(that.order) &&
        policyId.equals(that.policyId) &&
        gav.equals(that.gav);
  }

  @Override
  public int hashCode() {
    return Objects.hash(order, policyId, gav, isOnline);
  }

  @Override
  public String toString() {
    return "{" + "order=" + order + ", policy_id=" + policyId + ", gav=" + gav + ", online=" + isOnline + '}';
  }
}
