/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.metrics.sender;

import static com.mulesoft.mule.runtime.gw.api.time.period.Period.seconds;
import static com.mulesoft.mule.runtime.gw.backoff.scheduler.configuration.SchedulingConfiguration.configuration;

import org.mule.runtime.api.lifecycle.InitialisationException;

import com.mulesoft.mule.runtime.gw.api.config.GatewayConfiguration;
import com.mulesoft.mule.runtime.gw.backoff.configuration.BackoffConfiguration;
import com.mulesoft.mule.runtime.gw.backoff.scheduler.BackoffScheduler;
import com.mulesoft.mule.runtime.gw.backoff.scheduler.configuration.SchedulingConfiguration;
import com.mulesoft.mule.runtime.gw.backoff.scheduler.factory.VariableExecutorBackoffSchedulerFactory;
import com.mulesoft.mule.runtime.gw.client.ApiPlatformClient;
import com.mulesoft.mule.runtime.gw.metrics.event.Event;
import com.mulesoft.mule.runtime.gw.metrics.serialization.EventMapper;
import com.mulesoft.mule.runtime.gw.queue.SizeLimitedQueue;
import com.mulesoft.mule.runtime.gw.retry.barrier.BackoffWhilstAlone;

import java.util.concurrent.ScheduledExecutorService;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsScheduler implements StatusListener {

  private static final Logger LOGGER = LoggerFactory.getLogger(MetricsScheduler.class);

  private BackoffScheduler backoffScheduler;
  private ApiPlatformClient apiPlatformClient;
  private MetricsSenderRunnable metricsSenderRunnable;
  private SizeLimitedQueue<Event> senderEventQueue;

  private String uuid;

  public MetricsScheduler(String uuid, SizeLimitedQueue<Event> senderEventQueue, ApiPlatformClient apiPlatformClient,
                          ScheduledExecutorService executorService) {
    this.uuid = uuid;
    this.apiPlatformClient = apiPlatformClient;
    this.senderEventQueue = senderEventQueue;
    this.backoffScheduler = new VariableExecutorBackoffSchedulerFactory().create(executorService);
  }

  @Override
  public void initialise() throws InitialisationException {
    LOGGER.debug("Starting Metrics scheduler for pushing events.");

    BackoffConfiguration backoffConfiguration = new BackoffConfiguration.Builder(new GatewayConfiguration()).build();

    metricsSenderRunnable = new MetricsSenderRunnable(metricsEventMapper(),
                                                      senderEventQueue, apiPlatformClient,
                                                      backoffConfiguration,
                                                      new BackoffWhilstAlone<>());

    backoffScheduler.scheduleWithFixedDelay(metricsSenderRunnable, metricsSchedulerConfiguration());
  }

  @Override
  public void dispose() {
    backoffScheduler.dispose();
  }

  private EventMapper metricsEventMapper() {
    return new EventMapper(uuid, apiPlatformClient.getOrgId());
  }

  private SchedulingConfiguration metricsSchedulerConfiguration() {
    return configuration(seconds(0), seconds(new GatewayConfiguration().metrics().getMetricsPushEventsFrequency()));
  }
}
