/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.metrics.sender;

import com.mulesoft.mule.runtime.gw.backoff.configuration.BackoffConfiguration;
import com.mulesoft.mule.runtime.gw.backoff.scheduler.runnable.BackoffRunnable;
import com.mulesoft.mule.runtime.gw.backoff.session.BackoffBarrier;
import com.mulesoft.mule.runtime.gw.backoff.session.SessionMetadata;
import com.mulesoft.mule.runtime.gw.client.ApiPlatformClient;
import com.mulesoft.mule.runtime.gw.client.session.metadata.ApiPlatformSessionMetadata;
import com.mulesoft.mule.runtime.gw.metrics.event.Event;
import com.mulesoft.mule.runtime.gw.metrics.serialization.EventMapper;
import com.mulesoft.mule.runtime.gw.queue.SizeLimitedQueue;
import com.mulesoft.mule.runtime.gw.retry.session.ErrorSessionMetadata;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsSenderRunnable
extends BackoffRunnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetricsSenderRunnable.class);
    private final EventMapper eventMapper;
    private final SizeLimitedQueue<Event> senderEventQueue;
    private final ApiPlatformClient apiPlatformClient;
    private BackoffConfiguration backoffConfiguration;

    public MetricsSenderRunnable(EventMapper eventMapper, SizeLimitedQueue<Event> senderEventQueue, ApiPlatformClient apiPlatformClient, BackoffConfiguration configuration, BackoffBarrier backoffBarrier) {
        super(configuration, backoffBarrier);
        this.backoffConfiguration = configuration;
        this.eventMapper = eventMapper;
        this.senderEventQueue = senderEventQueue;
        this.apiPlatformClient = apiPlatformClient;
    }

    protected SessionMetadata execute() {
        int statusCode = 200;
        List<Event> events = this.getEvents();
        try {
            if (!events.isEmpty() && this.isFailureStatusCode(statusCode = this.apiPlatformClient.postMetrics(this.eventMapper.serialize(events)))) {
                this.preserveEvents(events);
            }
        }
        catch (Throwable e) {
            LOGGER.debug("Unable to post metrics.", e);
            this.preserveEvents(events);
            return new ErrorSessionMetadata();
        }
        return new ApiPlatformSessionMetadata(statusCode);
    }

    private void preserveEvents(List<Event> events) {
        events.forEach(arg_0 -> this.senderEventQueue.add(arg_0));
    }

    private boolean isFailureStatusCode(int statusCode) {
        return this.backoffConfiguration.statusCodes().contains(statusCode);
    }

    private List<Event> getEvents() {
        ArrayList<Event> events = new ArrayList<Event>();
        Optional event = this.senderEventQueue.retrieve();
        while (event.isPresent()) {
            events.add((Event)event.get());
            event = this.senderEventQueue.retrieve();
        }
        return events;
    }
}

