/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.metrics.event;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.Objects;

public class ApiDeployed extends ApiEvent {

  private static final long serialVersionUID = 1618057674429376361L;

  @JsonProperty(value = "app_name")
  private String name;

  @JsonProperty(value = "domain_name")
  private String domainName;

  public ApiDeployed() {}

  public ApiDeployed(long id, String artifactName, String domainName, long time) {
    super(id, time);
    this.name = artifactName;
    this.domainName = domainName;
  }

  @Override
  public <T> T accept(EventVisitor<T> visitor) {
    return visitor.visit(this);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }

    ApiDeployed apiDeployed = (ApiDeployed) o;
    return super.equals(o) &&
        name.equals(apiDeployed.name) &&
        domainName.equals(apiDeployed.domainName);
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), name, domainName);
  }

  @Override
  public String toString() {
    return "{" + "id=" + id + ", apiName=" + name + ", domainName=" + domainName + '}';
  }
}
