/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.metrics.event;

import java.io.Serializable;

/**
 * Represents a metrics event, this event will be forwarded to the appropriate backend that will collect, process and compare them
 * to extract business decisions.
 */
public abstract class Event implements Serializable {

  protected long time;

  public Event() {}

  public Event(long time) {
    this.time = time;
  }

  /**
   * @return Time of creation of the event, in Epoch seconds. (Unix Timestamp)
   */
  public long time() {
    return time;
  }

  public abstract <T> T accept(EventVisitor<T> visitor);
}
