/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.metrics.event;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.Objects;

public abstract class PolicyEvent extends ApiEvent {

  private static final long serialVersionUID = 6247040751805654784L;

  @JsonProperty(value = "policy_id")
  private String policyId;

  @JsonProperty(value = "gav")
  private String gav;

  @JsonProperty(value = "online")
  private boolean isOnline;

  public PolicyEvent() {}

  public PolicyEvent(long apiId, String policyId, String gav, boolean isOnline, long time) {
    super(apiId, time);
    this.policyId = policyId;
    this.gav = gav;
    this.isOnline = isOnline;
  }

  @Override
  public boolean equals(Object o) {
    if (!super.equals(o)) {
      return false;
    }

    PolicyEvent that = (PolicyEvent) o;
    return isOnline == that.isOnline
        && Objects.equals(policyId, that.policyId)
        && Objects.equals(gav, that.gav);
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), policyId, gav, isOnline);
  }
}
