/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.metrics.event.information;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

public class AnalyticsInformation implements Serializable {

  private static final long serialVersionUID = -7885950413093220755L;

  @JsonProperty(value = "enabled")
  private boolean analyticsEnabled;

  @JsonProperty(value = "frequency")
  private int analyticsPushFrequency;

  @JsonProperty(value = "use_agent")
  private boolean analyticsThroughAgent;

  public AnalyticsInformation() {}

  public AnalyticsInformation(boolean analyticsEnabled, int analyticsPushFrequency, boolean analyticsThroughAgent) {
    this.analyticsEnabled = analyticsEnabled;
    this.analyticsPushFrequency = analyticsPushFrequency;
    this.analyticsThroughAgent = analyticsThroughAgent;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }

    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AnalyticsInformation analyticsInformation = (AnalyticsInformation) o;
    return analyticsEnabled == analyticsInformation.analyticsEnabled &&
        analyticsPushFrequency == analyticsInformation.analyticsPushFrequency &&
        analyticsThroughAgent == analyticsInformation.analyticsThroughAgent;
  }

  @Override
  public int hashCode() {
    return Objects.hash(analyticsEnabled, analyticsPushFrequency, analyticsThroughAgent);
  }

  @Override
  public String toString() {
    return "{" + "analyticsEnabled=" + analyticsEnabled + ", analyticsPushFrequency=" + analyticsPushFrequency
        + ", analyticsThroughAgent=" + analyticsThroughAgent + '}';
  }

}
