/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.metrics.event.information;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

public class GatewaySecurityInformation implements Serializable {

  private static final long serialVersionUID = 3022902112331574175L;

  @JsonProperty(value = "hash_clients")
  private boolean hashClients;

  @JsonProperty(value = "encryptionEnabled")
  private boolean encryptionEnabled;

  @JsonProperty(value = "sensitive_only")
  private boolean encryptSensitiveOnly;

  public GatewaySecurityInformation() {}

  public GatewaySecurityInformation(boolean hashClients, boolean encryptionEnabled, boolean encryptSensitiveOnly) {
    this.hashClients = hashClients;
    this.encryptionEnabled = encryptionEnabled;
    this.encryptSensitiveOnly = encryptSensitiveOnly;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }

    if (o == null || getClass() != o.getClass()) {
      return false;
    }

    GatewaySecurityInformation gatewaySecurityInformation = (GatewaySecurityInformation) o;
    return hashClients == gatewaySecurityInformation.hashClients &&
        encryptionEnabled == gatewaySecurityInformation.encryptionEnabled &&
        encryptSensitiveOnly == gatewaySecurityInformation.encryptSensitiveOnly;
  }

  @Override
  public int hashCode() {
    return Objects.hash(hashClients, encryptionEnabled, encryptSensitiveOnly);
  }

  @Override
  public String toString() {
    return "{" + "hashClients=" + hashClients + ", encryptionEnabled=" + encryptionEnabled + ", encryptSensitiveOnly="
        + encryptSensitiveOnly + '}';
  }

}
