/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.metrics.event.status;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;

public class AppStatus implements Comparable<AppStatus>, Serializable {

  private static final long serialVersionUID = -2543627537268331778L;

  @JsonProperty(value = "name")
  private String artifactName;

  @JsonProperty(value = "apis")
  private List<ApiStatus> apis;

  public AppStatus() {}

  public AppStatus(String artifactName, List<ApiStatus> apis) {
    this.artifactName = artifactName;
    this.apis = apis;
  }

  @Override
  public int compareTo(AppStatus o) {
    return artifactName.compareTo(o.artifactName);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }

    if (o == null || getClass() != o.getClass()) {
      return false;
    }

    AppStatus that = (AppStatus) o;
    return artifactName.equals(that.artifactName) && apis.equals(that.apis);
  }

  @Override
  public int hashCode() {
    return Objects.hash(artifactName, apis);
  }

  @Override
  public String toString() {
    return "{" + "name=" + artifactName + ", apis=" + apis + '}';
  }
}
