/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.metrics.event.status;

import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public class RequestsPerApi {

  private Map<Long, AtomicLong> requestsPerApi;

  public RequestsPerApi(Map<Long, AtomicLong> requestsPerApi) {
    this.requestsPerApi = requestsPerApi;
  }

  public long requestsForApi(long apiId) {
    return requestsPerApi.getOrDefault(apiId, new AtomicLong()).get();
  }
}
