/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.metrics.serialization.dto;

import com.mulesoft.mule.runtime.gw.metrics.event.Event;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;

@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, property = "name")
@JsonSubTypes({
    @JsonSubTypes.Type(value = ApiDeployedDto.class, name = ApiDeployedDto.NAME),
    @JsonSubTypes.Type(value = ApiUndeployedDto.class, name = ApiUndeployedDto.NAME),
    @JsonSubTypes.Type(value = GatewayInformationDto.class, name = GatewayInformationDto.NAME),
    @JsonSubTypes.Type(value = GatewayStatusDto.class, name = GatewayStatusDto.NAME),
    @JsonSubTypes.Type(value = PolicyAppliedDto.class, name = PolicyAppliedDto.NAME),
    @JsonSubTypes.Type(value = PolicyRemovedDto.class, name = PolicyRemovedDto.NAME)
})
public abstract class EventDto {

  protected static final String ACTION_TYPE = "action";
  protected static final String SNAPSHOT_TYPE = "snapshot";
  private static final String DEFAULT_FORMAT_VERSION = "v2";

  @JsonProperty
  private String format = DEFAULT_FORMAT_VERSION;

  @JsonProperty
  private String type;

  @JsonProperty
  private long time;

  @JsonProperty
  private EventMetadata metadata;

  public EventDto() {}

  public EventDto(long time, EventMetadata metadata) {
    this.metadata = metadata;
    this.time = time;
    this.type = type();
  }

  public abstract Event getProperties();

  protected String type() {
    return ACTION_TYPE;
  }

  public EventMetadata getMetadata() {
    return metadata;
  }
}
