/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.metrics.serialization.dto;

import com.mulesoft.mule.runtime.gw.metrics.event.Event;
import com.mulesoft.mule.runtime.gw.metrics.event.PolicyApplied;

import com.fasterxml.jackson.annotation.JsonProperty;

public class PolicyAppliedDto extends EventDto {

  protected static final String NAME = "policy_applied";

  @JsonProperty
  private PolicyApplied properties;

  public PolicyAppliedDto() {}

  public PolicyAppliedDto(EventMetadata metadata, PolicyApplied properties) {
    super(properties.time(), metadata);
    this.properties = properties;
  }

  @Override
  public Event getProperties() {
    return properties;
  }
}
