/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.metrics.event.status;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;

public class ApiStatus implements Comparable<ApiStatus>, Serializable {

  private static final long serialVersionUID = -2090729439024505221L;

  @JsonProperty("api_id")
  private Long apiId;

  @JsonProperty("tracked")
  private boolean tracked;

  @JsonProperty("endpoint_type")
  private String endpointType;

  @JsonProperty("policies")
  private List<PolicyStatus> policies;

  @JsonProperty("received_requests")
  private long receivedRequests;

  @JsonProperty("domain")
  private String domain;

  public ApiStatus() {}

  public ApiStatus(Long apiId, String domain, boolean tracked, String endpointType,
                   List<PolicyStatus> policies, long receivedRequests) {
    this.apiId = apiId;
    this.domain = domain;
    this.tracked = tracked;
    this.endpointType = endpointType;
    this.policies = policies;
    this.receivedRequests = receivedRequests;
  }

  @Override
  public int compareTo(ApiStatus o) {
    return apiId.compareTo(o.apiId);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }

    if (o == null || getClass() != o.getClass()) {
      return false;
    }

    ApiStatus that = (ApiStatus) o;
    return tracked == that.tracked &&
        apiId.equals(that.apiId) &&
        domain.equals(that.domain) &&
        endpointType.equals(that.endpointType) &&
        policies.equals(that.policies) &&
        receivedRequests == that.receivedRequests;
  }

  @Override
  public int hashCode() {
    return Objects.hash(apiId, domain, tracked, endpointType, policies, receivedRequests);
  }

  @Override
  public String toString() {
    return "{" + "api_id=" + apiId + ", tracked=" + tracked + ", endpoint_type=" + endpointType + ", policies=" + policies
        + ", received_requests=" + receivedRequests + ", domain=" + domain + '}';
  }
}
