/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.metrics.serialization.dto;

import com.fasterxml.jackson.annotation.JsonProperty;

public class EventMetadata {

  private static final String DEFAULT_OWNER = "api-gateway";

  @JsonProperty
  private String owner = DEFAULT_OWNER;

  @JsonProperty("runtime_id")
  private String runtimeId;

  @JsonProperty("organization_id")
  private String organizationId;

  public EventMetadata() {}

  public EventMetadata(String runtimeId, String organizationId) {
    this.runtimeId = runtimeId;
    this.organizationId = organizationId;
  }

  public String getOwner() {
    return owner;
  }

  public String getRuntimeId() {
    return runtimeId;
  }

  public String getOrganizationId() {
    return organizationId;
  }
}
