/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.metrics.serialization.dto;

import com.mulesoft.mule.runtime.gw.metrics.event.Event;
import com.mulesoft.mule.runtime.gw.metrics.event.information.GatewayInformation;

import com.fasterxml.jackson.annotation.JsonProperty;

public class GatewayInformationDto extends EventDto {

  protected static final String NAME = "gateway_information";

  @JsonProperty
  private GatewayInformation properties;

  public GatewayInformationDto() {}

  public GatewayInformationDto(EventMetadata metadata, GatewayInformation properties) {
    super(properties.time(), metadata);
    this.properties = properties;
  }

  @Override
  public Event getProperties() {
    return properties;
  }
}
