/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.metrics.event;

import com.fasterxml.jackson.annotation.JsonProperty;

public abstract class ApiEvent extends Event {

  private static final long serialVersionUID = 6624619657272926665L;

  @JsonProperty(value = "api_id")
  protected long id;

  public ApiEvent() {}

  public ApiEvent(long id, long time) {
    super(time);
    this.id = id;
  }

  public long id() {
    return id;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }

    if (o == null || getClass() != o.getClass()) {
      return false;
    }

    ApiEvent apiEvent = (ApiEvent) o;
    return id == apiEvent.id;
  }
}
