/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.metrics.event.information;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

public class PlatformInformation implements Serializable {

  private static final long serialVersionUID = 451392477371741801L;

  @JsonProperty(value = "policies_polling_freq")
  private long policiesPollingFrequency;

  @JsonProperty(value = "clients_polling_freq")
  private long clientsPollingFrequency;

  @JsonProperty(value = "keep_alive_freq")
  private long keepAlivePollingFrequency;

  @JsonProperty(value = "via_proxy")
  private boolean connectingViaProxy;

  @JsonProperty(value = "backoff_enabled")
  private boolean backoffEnabled;

  public PlatformInformation() {}

  public PlatformInformation(long policiesPollingFrequency, long clientsPollingFrequency, long keepAlivePollingFrequency,
                             boolean connectingViaProxy, boolean backoffEnabled) {
    this.policiesPollingFrequency = policiesPollingFrequency;
    this.clientsPollingFrequency = clientsPollingFrequency;
    this.keepAlivePollingFrequency = keepAlivePollingFrequency;
    this.connectingViaProxy = connectingViaProxy;
    this.backoffEnabled = backoffEnabled;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }

    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PlatformInformation platformInformation = (PlatformInformation) o;
    return policiesPollingFrequency == platformInformation.policiesPollingFrequency &&
        clientsPollingFrequency == platformInformation.clientsPollingFrequency &&
        keepAlivePollingFrequency == platformInformation.keepAlivePollingFrequency &&
        connectingViaProxy == platformInformation.connectingViaProxy &&
        backoffEnabled == platformInformation.backoffEnabled;
  }

  @Override
  public int hashCode() {
    return Objects.hash(policiesPollingFrequency, clientsPollingFrequency, keepAlivePollingFrequency, connectingViaProxy,
                        backoffEnabled);
  }

  @Override
  public String toString() {
    return "{" + "policiesPollingFrequency=" + policiesPollingFrequency + ", clientsPollingFrequency=" + clientsPollingFrequency
        + ", keepAlivePollingFrequency=" + keepAlivePollingFrequency + ", connectingViaProxy=" + connectingViaProxy
        + ", backoffEnabled=" + backoffEnabled + '}';
  }

}
