/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.metrics.processor;

import com.mulesoft.mule.runtime.gw.metrics.event.Event;
import com.mulesoft.mule.runtime.gw.queue.SizeLimitedQueue;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * This processor queues the incoming events to a queue. The idea behind this is to process the events asynchronously and not when
 * they are generated. This way sending the events to the backend won't have an effect on performance.
 */
public class QueueEventProcessor implements Processor<Event> {

  private static final Logger LOGGER = LoggerFactory.getLogger(QueueEventProcessor.class);

  private SizeLimitedQueue<Event> senderEventQueue;

  public QueueEventProcessor(SizeLimitedQueue<Event> senderEventQueue) {
    this.senderEventQueue = senderEventQueue;
  }

  @Override
  public void accept(Event event) {
    senderEventQueue.add(event);
    LOGGER.trace("New accepted event successfully added.");
  }
}
