/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.metrics;

import com.mulesoft.mule.runtime.gw.metrics.event.ApiDeployed;
import com.mulesoft.mule.runtime.gw.metrics.event.ApiUndeployed;
import com.mulesoft.mule.runtime.gw.metrics.event.Event;
import com.mulesoft.mule.runtime.gw.metrics.event.PolicyApplied;
import com.mulesoft.mule.runtime.gw.metrics.event.PolicyRemoved;
import com.mulesoft.mule.runtime.gw.metrics.event.information.AnalyticsInformation;
import com.mulesoft.mule.runtime.gw.metrics.event.information.GatewayInformation;
import com.mulesoft.mule.runtime.gw.metrics.event.information.GatewaySecurityInformation;
import com.mulesoft.mule.runtime.gw.metrics.event.information.PlatformInformation;
import com.mulesoft.mule.runtime.gw.metrics.event.status.AppStatus;
import com.mulesoft.mule.runtime.gw.metrics.event.status.GatewayStatus;
import com.mulesoft.mule.runtime.gw.metrics.processor.Processor;
import java.time.Clock;
import java.util.List;
import org.mule.runtime.api.lifecycle.Disposable;

public class GatewayMetrics
implements Disposable {
    private Processor<Event> processor;
    private Clock clock = Clock.systemDefaultZone();

    public GatewayMetrics(Processor<Event> processor) {
        this.processor = processor;
    }

    public void apiDeployed(long apiId, String apiName, String domainName) {
        this.submit(new ApiDeployed(apiId, apiName, domainName, this.currentMillis()));
    }

    public void apiUndeployed(long apiId) {
        this.submit(new ApiUndeployed(apiId, this.currentMillis()));
    }

    public void policyDeployed(Long apiId, String policyId, String gav, boolean online) {
        this.submit(new PolicyApplied(apiId, policyId, gav, online, this.currentMillis()));
    }

    public void policyRemoved(Long apiId, String policyId, String gav, boolean online) {
        this.submit(new PolicyRemoved(apiId, policyId, gav, online, this.currentMillis()));
    }

    public void gatewayInformation(String runtimeVersion, String deploymentTarget, String gatekeeperMode, boolean clusterMode, GatewaySecurityInformation gatewaySecurityInformation, PlatformInformation platformInformation, AnalyticsInformation analyticsInformation) {
        this.submit(new GatewayInformation(runtimeVersion, deploymentTarget, gatekeeperMode, clusterMode, gatewaySecurityInformation, platformInformation, analyticsInformation, this.currentMillis()));
    }

    public void status(List<AppStatus> apps) {
        this.submit(new GatewayStatus(apps, this.currentMillis()));
    }

    private long currentMillis() {
        return this.clock.instant().getEpochSecond();
    }

    public void submit(Event event) {
        this.processor.accept(event);
    }

    public void dispose() {
        this.processor.dispose();
    }
}

