/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.metrics;

import com.mulesoft.mule.runtime.gw.api.config.GatewayConfiguration;
import com.mulesoft.mule.runtime.gw.client.ApiPlatformClient;
import com.mulesoft.mule.runtime.gw.deployment.api.ApiService;
import com.mulesoft.mule.runtime.gw.metrics.GatewayMetrics;
import com.mulesoft.mule.runtime.gw.metrics.GatewayMetricsAdapter;
import com.mulesoft.mule.runtime.gw.metrics.VariableRateExecutorService;
import com.mulesoft.mule.runtime.gw.metrics.event.Event;
import com.mulesoft.mule.runtime.gw.metrics.event.status.ApiRequestsTracker;
import com.mulesoft.mule.runtime.gw.metrics.processor.QueueEventProcessor;
import com.mulesoft.mule.runtime.gw.metrics.sender.MetricsScheduler;
import com.mulesoft.mule.runtime.gw.notification.ApiDeploymentListener;
import com.mulesoft.mule.runtime.gw.policies.service.PolicyDeploymentListener;
import com.mulesoft.mule.runtime.gw.policies.service.PolicyDeploymentTracker;
import com.mulesoft.mule.runtime.gw.queue.SizeLimitedQueue;
import com.mulesoft.mule.runtime.gw.queue.SizeLimitedQueueFactory;
import java.util.ArrayDeque;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import org.mule.runtime.core.api.util.concurrent.NamedThreadFactory;
import org.mule.runtime.module.deployment.api.DeploymentService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GatewayMetricsFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(GatewayMetricsFactory.class);
    public static final String AGW_METRICS_COLLECTOR_THREAD_NAME = "agw-metrics-collector";
    private static final int TO_SECONDS = 60;

    public Optional<GatewayMetricsAdapter> from(String runtimeId, ApiPlatformClient apiPlatformClient, GatewayConfiguration configuration, DeploymentService deploymentService, ApiService apiService, PolicyDeploymentTracker policyTracker) {
        if (!configuration.metrics().metricsEnabled().booleanValue() || configuration.platformClient().isOfflineModeEnabled()) {
            LOGGER.debug("Gateway metrics module is disabled, no gateway usage metrics will be generated.");
            return Optional.empty();
        }
        SizeLimitedQueue<Event> queue = this.queue(configuration.metrics().getMetricsCapacity());
        ScheduledExecutorService executorService = Executors.newScheduledThreadPool(1, (ThreadFactory)new NamedThreadFactory(AGW_METRICS_COLLECTOR_THREAD_NAME));
        int statusFrequency = configuration.metrics().getMetricsStatusFrequency();
        VariableRateExecutorService variableExecutor = new VariableRateExecutorService(executorService, this.startingDelay(statusFrequency));
        ApiRequestsTracker requestsTracker = new ApiRequestsTracker(apiService);
        GatewayMetricsAdapter adapter = new GatewayMetricsAdapter(new GatewayMetrics(new QueueEventProcessor(queue)), deploymentService, apiService, policyTracker, variableExecutor, requestsTracker, new MetricsScheduler(runtimeId, queue, apiPlatformClient, executorService));
        adapter.generateStatusAtRate(statusFrequency);
        policyTracker.addPolicyDeploymentListener((PolicyDeploymentListener)adapter);
        apiService.addDeploymentListener((ApiDeploymentListener)adapter);
        apiService.addDeploymentListener((ApiDeploymentListener)requestsTracker);
        return Optional.of(adapter);
    }

    private int startingDelay(int maximum) {
        int min = maximum / 10;
        int max = maximum - min;
        return min + new Random().nextInt(max);
    }

    SizeLimitedQueue<Event> queue(int queueCapacity) {
        return new SizeLimitedQueueFactory().createConcurrentCircularQueue(new ArrayDeque(queueCapacity), queueCapacity);
    }
}

