/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.policies.template;

import com.mulesoft.anypoint.tests.PolicyTestValuesConstants;
import com.mulesoft.mule.runtime.gw.policies.template.PolicyTemplate;
import com.mulesoft.mule.runtime.gw.policies.template.exception.PolicyTemplateResolverException;
import com.mulesoft.mule.runtime.gw.policies.template.provider.PolicyTemplateProvider;
import com.mulesoft.mule.runtime.gw.policies.template.resolver.HandlebarsPolicyTemplateResolver;
import com.mulesoft.mule.runtime.gw.policies.template.resolver.PolicyTemplateResolver;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;
import org.mockito.Mockito;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.xml.sax.SAXException;

public class HandlebarsPolicyTemplateResolverTestCase
extends AbstractMuleTestCase {
    private static final Item ITEM = new Item("Item 1", "$19.99", Arrays.asList(new Feature("New!"), new Feature("Awesome!")));
    private static final Item ITEM_2 = new Item("Item 2", "$29.99", Arrays.asList(new Feature("Old."), new Feature("Ugly.")));
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private Map<String, Object> configurationData;
    private PolicyTemplate template;
    private PolicyTemplateResolver policyTemplateResolver;

    @Before
    public void setUp() throws IOException, URISyntaxException {
        this.configurationData = new HashMap<String, Object>();
        File templateFile = new File(((Object)((Object)this)).getClass().getResource("/templates/template.xml").getFile());
        this.template = (PolicyTemplate)Mockito.mock(PolicyTemplate.class);
        Mockito.when((Object)this.template.getTemplateFile()).thenReturn((Object)templateFile);
        Mockito.when((Object)this.template.getKey()).thenReturn((Object)PolicyTestValuesConstants.POLICY_TEMPLATE_KEY);
        PolicyTemplateProvider templateProvider = (PolicyTemplateProvider)Mockito.mock(PolicyTemplateProvider.class);
        Mockito.when((Object)templateProvider.provide(PolicyTestValuesConstants.POLICY_TEMPLATE_KEY)).thenReturn((Object)this.template);
        this.policyTemplateResolver = new HandlebarsPolicyTemplateResolver();
        XMLUnit.setIgnoreWhitespace((boolean)true);
    }

    @Test
    public void resolveTemplate() throws IOException, PolicyTemplateResolverException {
        this.configurationData.put("items", Arrays.asList(ITEM, ITEM_2));
        this.configurationData.put("boolean", true);
        String resolvedTemplate = this.policyTemplateResolver.resolve(this.template, this.configurationData);
        Assert.assertThat((Object)resolvedTemplate, (Matcher)Matchers.is((Object)IOUtils.getResourceAsString((String)"templates/resolved-template.xml", ((Object)((Object)this)).getClass())));
    }

    @Test
    public void resolveTemplateWithEqualsHelperA() throws IOException, PolicyTemplateResolverException, SAXException {
        File templateFile = new File(((Object)((Object)this)).getClass().getResource("/templates/template-with-equals-helper.xml").getFile());
        Mockito.when((Object)this.template.getTemplateFile()).thenReturn((Object)templateFile);
        this.configurationData.put("value", "A");
        String resolvedTemplate = this.policyTemplateResolver.resolve(this.template, this.configurationData);
        XMLAssert.assertXMLEqual((String)resolvedTemplate, (String)IOUtils.getResourceAsString((String)"templates/resolved-template-with-equals-helper-a.xml", ((Object)((Object)this)).getClass()));
    }

    @Test
    public void resolveTemplateWithEqualsHelperB() throws IOException, PolicyTemplateResolverException, SAXException {
        File templateFile = new File(((Object)((Object)this)).getClass().getResource("/templates/template-with-equals-helper.xml").getFile());
        Mockito.when((Object)this.template.getTemplateFile()).thenReturn((Object)templateFile);
        this.configurationData.put("value", "B");
        String resolvedTemplate = this.policyTemplateResolver.resolve(this.template, this.configurationData);
        XMLAssert.assertXMLEqual((String)resolvedTemplate, (String)IOUtils.getResourceAsString((String)"templates/resolved-template-with-equals-helper-b.xml", ((Object)((Object)this)).getClass()));
    }

    @Test
    public void resolveTemplateWithEqualsHelperC() throws IOException, PolicyTemplateResolverException, SAXException {
        File templateFile = new File(((Object)((Object)this)).getClass().getResource("/templates/template-with-equals-helper.xml").getFile());
        Mockito.when((Object)this.template.getTemplateFile()).thenReturn((Object)templateFile);
        this.configurationData.put("value", "C");
        String resolvedTemplate = this.policyTemplateResolver.resolve(this.template, this.configurationData);
        XMLAssert.assertXMLEqual((String)resolvedTemplate, (String)IOUtils.getResourceAsString((String)"templates/resolved-template-with-equals-helper-c.xml", ((Object)((Object)this)).getClass()));
    }

    @Test
    public void parseTemplateWithUnusedScope() throws IOException, PolicyTemplateResolverException {
        this.configurationData.put("items", Arrays.asList(ITEM, ITEM_2));
        this.configurationData.put("unusedScope", "value");
        this.configurationData.put("boolean", true);
        String resolvedTemplate = this.policyTemplateResolver.resolve(this.template, this.configurationData);
        Assert.assertThat((Object)resolvedTemplate, (Matcher)Matchers.is((Object)IOUtils.getResourceAsString((String)"templates/resolved-template.xml", ((Object)((Object)this)).getClass())));
    }

    @Test
    public void parseTemplateWithTemplateVarsNotEvaluated() throws IOException, PolicyTemplateResolverException {
        this.configurationData.put("unusedScope", "value");
        String resolvedTemplate = this.policyTemplateResolver.resolve(this.template, this.configurationData);
        Assert.assertThat((Object)resolvedTemplate, (Matcher)Matchers.is((Object)IOUtils.getResourceAsString((String)"templates/empty-template.xml", ((Object)((Object)this)).getClass())));
    }

    static class Item {
        private List<Feature> features;
        private String name;
        private String price;

        Item(String name, String price, List<Feature> features) {
            this.name = name;
            this.price = price;
            this.features = features;
        }

        public String getName() {
            return this.name;
        }

        public String getPrice() {
            return this.price;
        }

        public List<Feature> getFeatures() {
            return this.features;
        }
    }

    static class Feature {
        private String description;

        Feature(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

