/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.policies;

import static com.mulesoft.mule.runtime.gw.policies.PolicyDeploymentStatus.DeploymentStatus.DEPLOYMENT_FAILED;
import static com.mulesoft.mule.runtime.gw.policies.PolicyDeploymentStatus.DeploymentStatus.DEPLOYMENT_SUCCESS;
import static com.mulesoft.mule.runtime.gw.policies.PolicyDeploymentStatus.DeploymentStatus.TEMPLATE_DOWNLOAD_FAILED;

import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;

import java.util.Objects;

//TODO: (AGW-1369) Review the Policy model
public class PolicyDeploymentStatus {

  private Policy policy;

  // NOTE: This field must not be removed as long as TITA relies on it for determining if a policy was deployed successfully or not.
  private PolicyDefinition policyDefinition;

  private DeploymentStatus deploymentStatus;

  public PolicyDeploymentStatus(Policy policy, DeploymentStatus applied) {
    this.policy = policy;
    this.deploymentStatus = applied;
    this.policyDefinition = policy.getPolicyDefinition();
  }

  public boolean isDeploymentSuccess() {
    return DEPLOYMENT_SUCCESS.equals(deploymentStatus);
  }

  public boolean isTemplateDownloadFailed() {
    return TEMPLATE_DOWNLOAD_FAILED.equals(deploymentStatus);
  }

  public boolean isDeploymentFailed() {
    return DEPLOYMENT_FAILED.equals(deploymentStatus);
  }

  public Policy getPolicy() {
    return policy;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }

    if (o == null || getClass() != o.getClass()) {
      return false;
    }

    PolicyDeploymentStatus status = (PolicyDeploymentStatus) o;
    return Objects.equals(policy, status.policy) &&
        deploymentStatus == status.deploymentStatus;
  }

  @Override
  public int hashCode() {
    return Objects.hash(policy, deploymentStatus);
  }

  public enum DeploymentStatus {
    DEPLOYMENT_SUCCESS, DEPLOYMENT_FAILED, TEMPLATE_DOWNLOAD_FAILED
  }
}
